/*
 * Decompiled with CFR 0.152.
 */
package geom.entities;

import geom.CompositeShape;
import geom.ShapeVisitor;
import gui.handlers.ColorHandler;
import gui.panels.ToolBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import org.kabeja.dxf.DXFLayer;

public final class Layer
extends CompositeShape {
    private final DXFLayer layer;
    private ColorHandler colorHandler = ToolBar.getColorHandler(false);

    public Layer(DXFLayer layer) {
        this.layer = layer;
        this.setVisible(this.getDefaultVisibility());
        this.init();
    }

    public boolean getDefaultVisibility() {
        return this.layer.isVisible() && !this.layer.isFrozen();
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
        super.accept(visitor);
    }

    public String getName() {
        return this.layer.getName();
    }

    @Override
    protected Color makeColor() {
        return this.colorHandler.toColor(this.layer.getColor());
    }

    @Override
    protected Color makeFillColor() {
        return null;
    }

    @Override
    protected Path2D makeClip() {
        return null;
    }

    @Override
    protected BasicStroke makeStroke() {
        return null;
    }

    @Override
    protected AffineTransform makeTransform() {
        return null;
    }

    public ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public void setColorHandler(ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
    }
}

