/*
 * Decompiled with CFR 0.152.
 */
package geom.entities;

import geom.AbstractShape;
import geom.ShapeVisitor;
import gui.handlers.ColorHandler;
import gui.panels.ToolBar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.kabeja.dxf.DXFEntity;

public abstract class Entity<T extends DXFEntity>
extends AbstractShape {
    private final T entity;
    private Shape shape;
    private ColorHandler colorHandler = ToolBar.getColorHandler(false);
    public static final int COLOR_BYBLOCK = 0;
    public static final int COLOR_BYLAYER = 256;

    protected Entity(T entity) {
        this.entity = entity;
    }

    @Override
    public final void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected final void init() {
        super.init();
        this.shape = this.makeShape();
    }

    @Override
    protected final Color makeColor() {
        if (((DXFEntity)this.entity).getColor() != 0 && ((DXFEntity)this.entity).getColor() != 256) {
            return this.colorHandler.toColor(((DXFEntity)this.entity).getColor());
        }
        return null;
    }

    @Override
    protected Color makeFillColor() {
        return null;
    }

    @Override
    protected void doFill(Graphics2D g2d) {
        g2d.fill(this.shape);
    }

    @Override
    protected void doDraw(Graphics2D g2d) {
        g2d.draw(this.shape);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    @Override
    public final AbstractShape doMatch(String handle) {
        if (this.getHandle().equals(handle)) {
            return this;
        }
        return null;
    }

    @Override
    public final AbstractShape doMatch(Point2D p) {
        if (this.contains(p)) {
            return this;
        }
        return null;
    }

    @Override
    public final String getHandle() {
        return ((DXFEntity)this.entity).getID();
    }

    @Override
    public final Point2D getPosition() {
        Rectangle2D b = this.shape.getBounds2D();
        return new Point2D.Double(b.getCenterX(), b.getCenterY());
    }

    protected abstract Shape makeShape();

    public final T getEntity() {
        return this.entity;
    }

    public final Shape getShape() {
        return this.shape;
    }

    public ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public void setColorHandler(ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
    }
}

