/*
 * Decompiled with CFR 0.152.
 */
package geom.entities;

import geom.CompositeShape;
import gui.handlers.ColorHandler;
import gui.panels.ToolBar;
import java.awt.Color;
import org.kabeja.dxf.DXFEntity;

public abstract class CompositeEntity<T extends DXFEntity>
extends CompositeShape {
    private final T entity;
    private ColorHandler colorHandler = ToolBar.getColorHandler(false);
    public static final int COLOR_BYBLOCK = 0;
    public static final int COLOR_BYLAYER = 256;

    protected CompositeEntity(T entity) {
        this.entity = entity;
    }

    @Override
    protected final void init() {
        super.init();
        this.addShapes();
    }

    @Override
    public final String getHandle() {
        return ((DXFEntity)this.entity).getID();
    }

    @Override
    protected final Color makeColor() {
        if (((DXFEntity)this.entity).getColor() != 0 && ((DXFEntity)this.entity).getColor() != 256) {
            return this.colorHandler.toColor(((DXFEntity)this.entity).getColor());
        }
        return null;
    }

    @Override
    protected Color makeFillColor() {
        return null;
    }

    protected abstract void addShapes();

    public final T getEntity() {
        return this.entity;
    }

    public ColorHandler getColorHandler() {
        return this.colorHandler;
    }

    public void setColorHandler(ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
    }
}

