/*
 * Decompiled with CFR 0.152.
 */
package geom;

import geom.AbstractShape;
import geom.ShapeVisitor;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class CompositeShape
extends AbstractShape
implements Iterable<AbstractShape> {
    private final List<AbstractShape> shapes = new ArrayList<AbstractShape>();

    @Override
    protected final void doDraw(Graphics2D g2d) {
        for (AbstractShape shape : this.shapes) {
            shape.draw(g2d);
        }
    }

    @Override
    protected void doFill(Graphics2D g2d) {
        if (this.getClip() != null) {
            g2d.fill(this.getClip());
        }
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        for (AbstractShape shape : this.shapes) {
            shape.accept(visitor);
        }
    }

    @Override
    public boolean contains(Point2D p) {
        for (AbstractShape shape : this.shapes) {
            if (!shape.contains(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractShape doMatch(String handle) {
        for (AbstractShape shape : this.shapes) {
            AbstractShape matched = shape.match(handle);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    @Override
    public AbstractShape doMatch(Point2D p) {
        for (AbstractShape shape : this.shapes) {
            AbstractShape matched = shape.match(p);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    @Override
    public String getHandle() {
        StringBuilder sb = new StringBuilder(this.shapes.get(0).getHandle());
        int l = this.shapes.size();
        for (int i = 1; i < l; ++i) {
            sb.append(",");
            sb.append(this.shapes.get(i));
        }
        return sb.toString();
    }

    @Override
    public Point2D getPosition() {
        double x = 0.0;
        double y = 0.0;
        for (AbstractShape shape : this.shapes) {
            Point2D p = shape.getPosition();
            x += p.getX();
            y += p.getY();
        }
        return new Point2D.Double(x / (double)this.shapes.size(), y / (double)this.shapes.size());
    }

    public final void add(AbstractShape shape) {
        this.shapes.add(shape);
    }

    public final void addAll(CompositeShape compositeShape) {
        for (AbstractShape shape : compositeShape) {
            this.shapes.add(shape);
        }
    }

    public final void remove(AbstractShape shape) {
        this.shapes.remove(shape);
    }

    public final void clear() {
        this.shapes.clear();
    }

    public final int size() {
        return this.shapes.size();
    }

    public final AbstractShape get(int index) {
        return this.shapes.get(index);
    }

    @Override
    public Iterator<AbstractShape> iterator() {
        return this.shapes.iterator();
    }

    public void sort(Comparator c) {
        Collections.sort(this.shapes, c);
    }
}

