/*
 * Decompiled with CFR 0.152.
 */
package geom;

import geom.ShapeElement;
import geom.ShapeVisitor;
import geom.entities.shapes.Arc;
import geom.entities.shapes.Attrib;
import geom.entities.shapes.Circle;
import geom.entities.shapes.Ellipse;
import geom.entities.shapes.Hatch;
import geom.entities.shapes.Insert;
import geom.entities.shapes.LWPolyline;
import geom.entities.shapes.Line;
import geom.entities.shapes.MText;
import geom.entities.shapes.Polyline;
import geom.entities.shapes.Solid;
import geom.entities.shapes.Text;
import geom.entities.shapes.Trace;
import geom.exceptions.DxfTypeNotFoundException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFAttrib;
import org.kabeja.dxf.DXFCircle;
import org.kabeja.dxf.DXFEllipse;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFInsert;
import org.kabeja.dxf.DXFLWPolyline;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFMText;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFSolid;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.DXFTrace;

public abstract class AbstractShape
implements ShapeElement {
    private boolean visible = true;
    private boolean interactive;
    private Color color;
    private Color fillColor;
    private AffineTransform transform;
    private BasicStroke stroke;
    private Shape clip;

    protected void init() {
        this.transform = this.makeTransform();
        this.stroke = this.makeStroke();
        this.clip = this.makeClip();
        this.color = this.makeColor();
        this.fillColor = this.makeFillColor();
    }

    public void initColor() {
        this.color = this.makeColor();
    }

    protected abstract AffineTransform makeTransform();

    protected abstract BasicStroke makeStroke();

    protected abstract Path2D makeClip();

    protected abstract Color makeColor();

    protected abstract Color makeFillColor();

    protected abstract void doDraw(Graphics2D var1);

    protected abstract void doFill(Graphics2D var1);

    protected abstract AbstractShape doMatch(String var1);

    protected abstract AbstractShape doMatch(Point2D var1);

    public abstract boolean contains(Point2D var1);

    public abstract String getHandle();

    public abstract Point2D getPosition();

    @Override
    public abstract void accept(ShapeVisitor var1);

    public final AbstractShape match(Point2D p) {
        if (this.visible && this.interactive) {
            return this.doMatch(p);
        }
        return null;
    }

    public final AbstractShape match(String handle) {
        if (this.visible && this.interactive) {
            return this.doMatch(handle);
        }
        return null;
    }

    public final void draw(Graphics2D g2d) {
        AffineTransform savedTransform = null;
        BasicStroke savedStroke = null;
        Color savedColor = null;
        Shape savedClip = null;
        if (this.transform != null) {
            savedTransform = g2d.getTransform();
            g2d.transform(this.transform);
        }
        if (this.color != null) {
            savedColor = g2d.getColor();
            g2d.setColor(this.color);
        }
        if (this.fillColor != null) {
            Color savedFillColor = g2d.getColor();
            g2d.setColor(this.fillColor);
            this.doFill(g2d);
            g2d.setColor(savedFillColor);
        }
        if (this.stroke != null) {
            savedStroke = (BasicStroke)g2d.getStroke();
            g2d.setStroke(new CompositeStroke(savedStroke, this.stroke));
        }
        if (this.clip != null) {
            savedClip = g2d.getClip();
            g2d.clip(this.clip);
        }
        if (this.visible) {
            this.doDraw(g2d);
        }
        if (savedClip != null) {
            g2d.setClip(savedClip);
        }
        if (savedStroke != null) {
            g2d.setStroke(savedStroke);
        }
        if (savedTransform != null) {
            g2d.setTransform(savedTransform);
        }
        if (savedColor != null) {
            g2d.setColor(savedColor);
        }
    }

    public static AbstractShape getShape(DXFEntity entity) throws DxfTypeNotFoundException {
        AbstractShape shape;
        switch (entity.getType()) {
            case "POLYLINE": {
                shape = new Polyline((DXFPolyline)entity);
                break;
            }
            case "LWPOLYLINE": {
                shape = new LWPolyline((DXFLWPolyline)entity);
                break;
            }
            case "LINE": {
                shape = new Line((DXFLine)entity);
                break;
            }
            case "CIRCLE": {
                shape = new Circle((DXFCircle)entity);
                break;
            }
            case "ELLIPSE": {
                shape = new Ellipse((DXFEllipse)entity);
                break;
            }
            case "ARC": {
                shape = new Arc((DXFArc)entity);
                break;
            }
            case "TEXT": {
                shape = new Text((DXFText)entity);
                break;
            }
            case "MTEXT": {
                shape = new MText((DXFMText)entity);
                break;
            }
            case "INSERT": {
                shape = new Insert((DXFInsert)entity);
                break;
            }
            case "HATCH": {
                shape = new Hatch(entity);
                break;
            }
            case "TRACE": {
                shape = new Trace((DXFTrace)entity);
                break;
            }
            case "SOLID": {
                shape = new Solid((DXFSolid)entity);
                break;
            }
            case "ATTRIB": {
                shape = new Attrib((DXFAttrib)entity);
                break;
            }
            default: {
                throw new DxfTypeNotFoundException(entity.getType());
            }
        }
        shape.init();
        return shape;
    }

    public final Color getColor() {
        return this.color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public Shape getClip() {
        return this.clip;
    }

    public static final class CompositeStroke
    extends BasicStroke {
        public CompositeStroke(BasicStroke stroke1, BasicStroke stroke2) {
            super(stroke1.getLineWidth() * stroke2.getLineWidth(), stroke2.getEndCap(), stroke2.getLineJoin(), stroke2.getMiterLimit(), stroke2.getDashArray(), stroke2.getDashPhase());
        }
    }
}

