/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.model.helpers;

import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import dao.RawSQL;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public abstract class AbstractCustomQueryBuilder {
    public static final String INT_YEAR = "SQL_TSI_YEAR";
    private final QueryBuilder qb;
    protected final RawSQL sql;
    private Where where;

    public AbstractCustomQueryBuilder(QueryBuilder qb, RawSQL sql) {
        this.qb = qb;
        this.sql = sql;
    }

    private void initWhere() {
        if (this.where == null) {
            this.where = this.qb.where();
        } else {
            this.where.and();
        }
    }

    public final Where where() {
        this.initWhere();
        return this.where;
    }

    public final QueryBuilder qb() {
        return this.qb;
    }

    public final List query() throws SQLException {
        return this.qb.query();
    }

    public final long count() throws SQLException {
        return this.qb().countOf();
    }

    protected void whereLike(String column, String value) throws SQLException {
        if (value == null) {
            this.where().isNull(column);
        } else {
            this.where().like(column, (Object)this.sql.joker(value));
        }
    }

    protected void whereRawLike(String column, String value) throws SQLException {
        if (value == null) {
            this.where().raw(this.sql.isNull(column), new ArgumentHolder[0]);
        } else {
            this.where().raw(this.sql.like(column, this.sql.joker(this.sql.escape(value))), new ArgumentHolder[0]);
        }
    }

    protected void whereEq(String column, Object value) throws SQLException {
        if (value == null) {
            this.where().isNull(column);
        } else {
            this.where().eq(column, value);
        }
    }

    protected void whereGL(String column, Object start, Object end) throws SQLException {
        if (start == null && end == null) {
            this.where().isNull(column);
        } else {
            if (start != null) {
                this.where().ge(column, start);
            }
            if (end != null) {
                this.where().le(column, end);
            }
        }
    }

    protected void whereRawGL(String column, String start, String end) {
        if (start == null && end == null) {
            this.where().raw(this.sql.isNull(column), new ArgumentHolder[0]);
        } else {
            if (start != null) {
                this.where().raw(this.sql.ge(column, this.sql.escape(start)), new ArgumentHolder[0]);
            }
            if (end != null) {
                this.where().raw(this.sql.le(column, this.sql.escape(end)), new ArgumentHolder[0]);
            }
        }
    }

    protected String toSQL(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime()).toString();
    }
}

