/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.model;

import beans.model.BurialPlot;
import beans.model.Deceased;
import beans.model.Location;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import dao.model.LocationDao;
import dao.ormlite.derby.DerbyRawSQL;
import dao.ormlite.model.BurialPlotOrmLiteDao;
import dao.ormlite.model.helpers.AbstractCustomQueryBuilder;
import java.sql.SQLException;
import java.util.List;

public final class LocationOrmLiteDao
extends BaseDaoImpl<Location, Integer>
implements LocationDao {
    public static final String ALPHA_SORT = "alpha";
    public static final String NUMERIC_SORT = "numeric";
    public static final String ALPHANUM_SORT = "alphanum";

    public LocationOrmLiteDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Location.class);
    }

    public CustomQueryBuilder customQueryBuilder() {
        return new CustomQueryBuilder(this.queryBuilder(), this.connectionSource);
    }

    @Override
    public List<Location> findAll(String sort) throws SQLException {
        return this.customQueryBuilder().order(sort).query();
    }

    @Override
    public List<Location> findBy(BurialPlotSO so, String sort) throws SQLException {
        return this.customQueryBuilder().by(so).order(sort).query();
    }

    @Override
    public List<Location> findBy(DeceasedSO so) throws SQLException {
        return this.customQueryBuilder().by(so).query();
    }

    @Override
    public List<Location> findBy(String handle) throws SQLException {
        return this.queryForEq("DXF_HANDLE", handle);
    }

    @Override
    public List<Location> search(String text) throws SQLException {
        return this.customQueryBuilder().byText(text).query();
    }

    @Override
    public List<Location> findBy(BurialPlot burialPlot) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).query();
    }

    @Override
    public List<Location> findBy(Deceased deceased) throws SQLException {
        return this.customQueryBuilder().by(deceased).query();
    }

    @Override
    public void dropTable(boolean ignoreErrors) throws SQLException {
        TableUtils.dropTable((Dao)this, (boolean)ignoreErrors);
    }

    @Override
    public void createTable() throws SQLException {
        TableUtils.createTable((Dao)this);
    }

    public static final class CustomQueryBuilder
    extends AbstractCustomQueryBuilder {
        private final ConnectionSource connectionSource;

        public CustomQueryBuilder(QueryBuilder queryBuilder, ConnectionSource connectionSource) {
            super(queryBuilder, new DerbyRawSQL("LOCATION"));
            this.connectionSource = connectionSource;
        }

        private BurialPlotOrmLiteDao getBurialPlotDao() throws SQLException {
            return (BurialPlotOrmLiteDao)DaoManager.createDao((ConnectionSource)this.connectionSource, BurialPlot.class);
        }

        public CustomQueryBuilder by(Deceased deceased) throws SQLException {
            QueryBuilder qb = this.getBurialPlotDao().customQueryBuilder().by(deceased).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder byText(String text) throws SQLException {
            QueryBuilder qb = this.getBurialPlotDao().customQueryBuilder().byText(text).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder by(BurialPlotSO burialPlotSO) throws SQLException {
            QueryBuilder qb = this.getBurialPlotDao().customQueryBuilder().by(burialPlotSO).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder by(DeceasedSO deceasedSO) throws SQLException {
            QueryBuilder qb = this.getBurialPlotDao().customQueryBuilder().by(deceasedSO).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder by(BurialPlot burialPlot) throws SQLException {
            QueryBuilder qb = this.getBurialPlotDao().customQueryBuilder().byId(burialPlot.getId()).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public void orderByAlphaNum() throws SQLException {
            this.qb().orderByRaw(this.sql.substr(this.sql.fqn("REFERENCE"), 1, 1)).orderByRaw(this.sql.cast(this.sql.substr(this.sql.fqn("REFERENCE"), 2), "INT"));
        }

        public void orderByAlpha() throws SQLException {
            this.qb().orderBy("REFERENCE", true);
        }

        public void orderByNum() throws SQLException {
            this.qb().orderByRaw(this.sql.cast(this.sql.fqn("REFERENCE"), "INT"));
        }

        public CustomQueryBuilder order(String type) throws SQLException {
            switch (type) {
                default: {
                    this.orderByAlpha();
                    break;
                }
                case "numeric": {
                    this.orderByNum();
                    break;
                }
                case "alphanum": {
                    this.orderByAlphaNum();
                }
            }
            return this;
        }
    }
}

