/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.model;

import beans.model.BurialPlot;
import beans.model.Deceased;
import beans.search.DeceasedSO;
import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import dao.model.DeceasedDao;
import dao.ormlite.derby.DerbyRawSQL;
import dao.ormlite.model.helpers.AbstractCustomQueryBuilder;
import java.sql.SQLException;
import java.util.List;

public final class DeceasedOrmLiteDao
extends BaseDaoImpl<Deceased, Integer>
implements DeceasedDao {
    public DeceasedOrmLiteDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Deceased.class);
    }

    public CustomQueryBuilder customQueryBuilder() {
        return new CustomQueryBuilder(this.queryBuilder());
    }

    @Override
    public List<Deceased> findBy(BurialPlot burialPlot) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).query();
    }

    @Override
    public List<Deceased> search(BurialPlot burialPlot, String text) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).byText(text).query();
    }

    @Override
    public List<Deceased> findBy(BurialPlot burialPlot, Integer id) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).byId(id).query();
    }

    @Override
    public List<Deceased> findBy(BurialPlot burialPlot, DeceasedSO dSO) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).by(dSO).query();
    }

    @Override
    public long countBy(BurialPlot burialPlot) throws SQLException {
        return this.customQueryBuilder().by(burialPlot).count();
    }

    @Override
    public void dropTable(boolean ignoreErrors) throws SQLException {
        TableUtils.dropTable((Dao)this, (boolean)ignoreErrors);
    }

    @Override
    public void createTable() throws SQLException {
        TableUtils.createTable((Dao)this);
    }

    public static final class CustomQueryBuilder
    extends AbstractCustomQueryBuilder {
        public CustomQueryBuilder(QueryBuilder queryBuilder) {
            super(queryBuilder, new DerbyRawSQL("DECEASED"));
        }

        public CustomQueryBuilder by(BurialPlot burialPlot) throws SQLException {
            this.where().eq("BURIAL_PLOT_ID", (Object)burialPlot.getId());
            return this;
        }

        public CustomQueryBuilder byId(Integer id) throws SQLException {
            this.where().eq("ID", (Object)id);
            return this;
        }

        public CustomQueryBuilder byText(String text) throws SQLException {
            String column = this.sql.concat(this.sql.nullToEmpty(this.sql.fqn("FIRST_NAME")), this.sql.nullToEmpty(this.sql.fqn("LAST_NAME")), "' '");
            this.whereRawLike(column, text);
            return this;
        }

        private void byFirstName(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithFirstName()) {
                this.whereLike("FIRST_NAME", deceasedSO.getFirstName());
            }
        }

        private void byLastName(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithLastName()) {
                this.whereLike("LAST_NAME", deceasedSO.getLastName());
            }
        }

        private void byBirthName(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithLastName()) {
                this.whereLike("LAST_NAME", deceasedSO.getLastName());
            }
        }

        private void byNickName(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithLastName()) {
                this.whereLike("LAST_NAME", deceasedSO.getLastName());
            }
        }

        private void byComments(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithComments()) {
                this.whereLike("COMMENTS", deceasedSO.getComments());
            }
        }

        private void byBirthDate(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithBirthDate()) {
                this.whereGL("BIRTH_DATE", deceasedSO.getBirthDateStart(), deceasedSO.getBirthDateEnd());
            }
        }

        private void byDeathDate(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithDeathDate()) {
                this.whereGL("DEATH_DATE", deceasedSO.getDeathDateStart(), deceasedSO.getDeathDateEnd());
            }
        }

        private void byDeceasedType(DeceasedSO deceasedSO) throws SQLException {
            if (deceasedSO.isWithDeceasedType()) {
                this.whereEq("DECEASED_TYPE_ID", deceasedSO.getDeceasedType());
            }
        }

        public CustomQueryBuilder by(DeceasedSO deceasedSO) throws SQLException {
            this.byFirstName(deceasedSO);
            this.byLastName(deceasedSO);
            this.byBirthName(deceasedSO);
            this.byNickName(deceasedSO);
            this.byComments(deceasedSO);
            this.byBirthDate(deceasedSO);
            this.byDeathDate(deceasedSO);
            this.byDeceasedType(deceasedSO);
            return this;
        }
    }
}

