/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.model;

import beans.model.BurialPlot;
import beans.model.Deceased;
import beans.model.Location;
import beans.search.BurialPlotSO;
import beans.search.DeceasedSO;
import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import dao.model.BurialPlotDao;
import dao.ormlite.derby.DerbyRawSQL;
import dao.ormlite.model.DeceasedOrmLiteDao;
import dao.ormlite.model.helpers.AbstractCustomQueryBuilder;
import java.sql.SQLException;
import java.util.List;

public final class BurialPlotOrmLiteDao
extends BaseDaoImpl<BurialPlot, Integer>
implements BurialPlotDao {
    public BurialPlotOrmLiteDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, BurialPlot.class);
    }

    public CustomQueryBuilder customQueryBuilder() {
        return new CustomQueryBuilder(this.queryBuilder(), this.getConnectionSource());
    }

    @Override
    public List<BurialPlot> findBy(Location location) throws SQLException {
        return this.customQueryBuilder().by(location).query();
    }

    @Override
    public List<BurialPlot> findBy(Location location, BurialPlotSO bpSO) throws SQLException {
        return this.customQueryBuilder().by(location).by(bpSO).query();
    }

    @Override
    public List<BurialPlot> findBy(Location location, DeceasedSO dSO) throws SQLException {
        return this.customQueryBuilder().by(location).by(dSO).query();
    }

    @Override
    public List<BurialPlot> search(Location location, String text) throws SQLException {
        return this.customQueryBuilder().by(location).byText(text).query();
    }

    @Override
    public List<BurialPlot> findBy(Location location, Deceased deceased) throws SQLException {
        return this.customQueryBuilder().by(location).by(deceased).query();
    }

    @Override
    public long countBy(BurialPlotSO burialPlotSO) throws SQLException {
        return this.customQueryBuilder().by(burialPlotSO).count();
    }

    @Override
    public long countBy(Location location) throws SQLException {
        return this.customQueryBuilder().by(location).count();
    }

    @Override
    public void dropTable(boolean ignoreErrors) throws SQLException {
        TableUtils.dropTable((Dao)this, (boolean)ignoreErrors);
    }

    @Override
    public void createTable() throws SQLException {
        TableUtils.createTable((Dao)this);
    }

    public static final class CustomQueryBuilder
    extends AbstractCustomQueryBuilder {
        private final ConnectionSource connectionSource;

        public CustomQueryBuilder(QueryBuilder queryBuilder, ConnectionSource connectionSource) {
            super(queryBuilder, new DerbyRawSQL("BURIAL_PLOT"));
            this.connectionSource = connectionSource;
        }

        private String getEndDateColumn() {
            return this.sql.dateAdd("SQL_TSI_YEAR", this.sql.fqn("DURATION"), this.sql.fqn("SELL_DATE"));
        }

        private DeceasedOrmLiteDao getDeceasedDao() throws SQLException {
            return (DeceasedOrmLiteDao)DaoManager.createDao((ConnectionSource)this.connectionSource, Deceased.class);
        }

        public CustomQueryBuilder by(Location location) throws SQLException {
            this.where().eq("LOCATION_ID", (Object)location.getId());
            return this;
        }

        public CustomQueryBuilder byId(Integer id) throws SQLException {
            this.where().eq("ID", (Object)id);
            return this;
        }

        private void byName(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithName()) {
                this.whereLike("NAME", burialPlotSO.getName());
            }
        }

        private void byReference(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithReference()) {
                this.whereLike("REFERENCE", burialPlotSO.getReference());
            }
        }

        private void byComments(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithComments()) {
                this.whereLike("COMMENTS", burialPlotSO.getComments());
            }
        }

        private void byBurialPlotType(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithBurialPlotType()) {
                this.whereEq("BURIAL_PLOT_TYPE_ID", burialPlotSO.getBurialPlotType());
            }
        }

        private void bySellDate(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithSellDate()) {
                this.whereGL("SELL_DATE", burialPlotSO.getSellDateStart(), burialPlotSO.getSellDateEnd());
            }
        }

        private void byEndDate(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithEndDate()) {
                if (burialPlotSO.getEndDateStart() == null && burialPlotSO.getEndDateEnd() == null) {
                    this.where().isNull("SELL_DATE");
                    this.where().isNull("CAPACITY");
                } else {
                    this.whereRawGL(this.getEndDateColumn(), this.toSQL(burialPlotSO.getEndDateStart()), this.toSQL(burialPlotSO.getEndDateEnd()));
                }
            }
        }

        private void byCapacity(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithCapacity()) {
                this.whereGL("CAPACITY", burialPlotSO.getCapacityStart(), burialPlotSO.getCapacityEnd());
            }
        }

        private void byDuration(BurialPlotSO burialPlotSO) throws SQLException {
            if (burialPlotSO.isWithDuration()) {
                this.whereGL("DURATION", burialPlotSO.getDurationStart(), burialPlotSO.getDurationEnd());
            }
        }

        public CustomQueryBuilder by(BurialPlotSO burialPlotSO) throws SQLException {
            this.byName(burialPlotSO);
            this.byReference(burialPlotSO);
            this.byComments(burialPlotSO);
            this.byBurialPlotType(burialPlotSO);
            this.bySellDate(burialPlotSO);
            this.byEndDate(burialPlotSO);
            this.byCapacity(burialPlotSO);
            this.byDuration(burialPlotSO);
            return this;
        }

        public CustomQueryBuilder by(DeceasedSO deceasedSO) throws SQLException {
            QueryBuilder qb = this.getDeceasedDao().customQueryBuilder().by(deceasedSO).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder by(Deceased deceased) throws SQLException {
            QueryBuilder qb = this.getDeceasedDao().customQueryBuilder().byId(deceased.getId()).qb();
            this.qb().distinct().join(qb);
            return this;
        }

        public CustomQueryBuilder byText(String text) throws SQLException {
            QueryBuilder qb = this.getDeceasedDao().customQueryBuilder().byText(text).qb();
            this.qb().distinct().join(qb);
            return this;
        }
    }
}

