/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.derby;

import dao.RawSQL;
import org.apache.commons.lang.StringEscapeUtils;

public final class DerbyRawSQL
implements RawSQL {
    private final String table;
    public static final String CAST_INT = "INT";

    public DerbyRawSQL(String table) {
        this.table = table;
    }

    @Override
    public String fqn(String column) {
        return "\"" + this.table + "\".\"" + column + "\"";
    }

    @Override
    public String escape(String value) {
        return StringEscapeUtils.escapeSql((String)value);
    }

    @Override
    public String concat(String value1, String value2, String glue) {
        return String.format("%s || %s || %s", value1, glue, value2);
    }

    @Override
    public String nullToEmpty(String value) {
        return String.format("CASE WHEN %s IS NULL THEN '' ELSE %s END", value, value);
    }

    @Override
    public String dateAdd(String type, String interval, String date) {
        return String.format("DATE({fn TIMESTAMPADD(%s, %s, %s)})", type, interval, date);
    }

    @Override
    public String between(String column, String start, String end) {
        return String.format("%s BETWEEN '%s' AND '%s'", column, start, end);
    }

    @Override
    public String ge(String column, String value) {
        return String.format("%s >= '%s'", column, value);
    }

    @Override
    public String le(String column, String value) {
        return String.format("%s <= '%s'", column, value);
    }

    @Override
    public String upper(String column) {
        return String.format("UPPER(%s)", column);
    }

    @Override
    public String like(String column, String value) {
        return String.format("%s LIKE '%s'", column, value);
    }

    @Override
    public String joker(String value) {
        return String.format("%%%s%%", value);
    }

    @Override
    public String substr(String column, int start, int offset) {
        return String.format("SUBSTR (%s, %d, %d)", column, start, offset);
    }

    @Override
    public String substr(String column, int start) {
        return String.format("SUBSTR (%s, %d)", column, start);
    }

    @Override
    public String cast(String column, String value) {
        return String.format("CAST (%s AS %s)", column, value);
    }

    @Override
    public String nullToString(String value) {
        return value == null ? "NULL" : value;
    }

    @Override
    public String isNull(String column) {
        return String.format("%s IS NULL", column);
    }

    @Override
    public String call(String value) {
        return String.format("CALL %s", value);
    }

    @Override
    public String dbProperty(String key, String value) {
        return String.format("SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('%s', '%s')", key, value);
    }
}

