/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite.derby;

import dao.DBConfig;
import org.apache.commons.configuration.Configuration;

public class DerbyConfig
implements DBConfig {
    public static final String P_USER = "user";
    public static final String P_PASSWORD = "password";
    public static final String P_DB = "derby";
    public static final String P_DRIVER = "jdbc";
    public static final String P_TERRITORY = "territory";
    public static final String P_COLLATION = "collation";
    public static final String P_CREATE = "create";
    public static final String P_SHUTDOWN = "shutdown";
    public static final String V_TRUE = "true";
    public static final String V_FALSE = "false";
    public static final String V_PRIMARY = "TERRITORY_BASED:PRIMARY";
    private final String name;
    private final String user;
    private final String password;
    private final String territory;
    private final URLBuilder builder;

    public DerbyConfig(Configuration configuration) {
        this.name = configuration.getString("dir.db");
        this.user = configuration.getString("db.user");
        this.password = configuration.getString("db.pass");
        this.territory = configuration.getString("db.terr");
        this.builder = new URLBuilder(P_DRIVER, P_DB, this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUrl() {
        return this.builder.getUrl();
    }

    @Override
    public String getCreateString() {
        return this.builder.addParam(P_USER, this.user).addParam(P_PASSWORD, this.password).addParam(P_CREATE, V_TRUE).addParam(P_TERRITORY, this.territory).addParam(P_COLLATION, V_PRIMARY).build();
    }

    @Override
    public String getShutdownString() {
        return this.builder.addParam(P_USER, this.user).addParam(P_PASSWORD, this.password).addParam(P_SHUTDOWN, V_TRUE).build();
    }

    private static final class URLBuilder {
        private final StringBuilder builder;
        private final String url;
        public static final String D_URL = ":";
        public static final String D_PAR = ";";
        public static final String D_EQU = "=";

        public URLBuilder(String driver, String db, String name) {
            this.url = this.buildURL(driver, db, name);
            this.builder = new StringBuilder(this.url);
        }

        private String buildURL(String driver, String db, String name) {
            return String.join((CharSequence)D_URL, driver, db, name);
        }

        public URLBuilder addParam(String param, String value) {
            this.builder.append(D_PAR).append(param).append(D_EQU).append(value);
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public String build() {
            return this.builder.toString();
        }
    }
}

