/*
 * Decompiled with CFR 0.152.
 */
package dao.ormlite;

import beans.model.BurialPlot;
import beans.model.BurialPlotType;
import beans.model.ChangeLog;
import beans.model.DateType;
import beans.model.Deceased;
import beans.model.DeceasedType;
import beans.model.Location;
import beans.model.LocationType;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import dao.DBConfig;
import dao.DaoFactory;
import dao.model.BurialPlotDao;
import dao.model.BurialPlotTypeDao;
import dao.model.ChangeLogDao;
import dao.model.DateTypeDao;
import dao.model.DeceasedDao;
import dao.model.DeceasedTypeDao;
import dao.model.LocationDao;
import dao.model.LocationTypeDao;
import dao.ormlite.derby.DerbyConfig;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OrmLiteDaoFactory
extends DaoFactory {
    public static final Log LOGGER = LogFactory.getLog(OrmLiteDaoFactory.class);
    private final DBConfig config;
    private final ResourceBundle resourceBundle;
    private ConnectionSource connectionSource;
    private final String[][] locationTypes = new String[][]{{"type.location.burialplot"}, {"type.location.colombarium"}, {"type.location.crypt"}, {"type.location.ossuary"}, {"type.location.pauper"}};
    private final String[][] burialPlotTypes = new String[][]{{"type.burialplot.temp"}, {"type.burialplot.ground"}, {"type.burialplot.grave"}, {"type.burialplot.small_vault"}, {"type.burialplot.vault_noroof"}, {"type.burialplot.vault"}, {"type.burialplot.family"}, {"type.burialplot.crypt"}, {"type.burialplot.urn"}, {"type.burialplot.colombarium"}, {"type.burialplot.ossuary"}, {"type.burialplot.pauper"}};
    private final String[][] deceasedTypes = new String[][]{{"type.deceased.coffin"}, {"type.deceased.zinc"}, {"type.deceased.urn"}};
    private final String[][] dateTypes = new String[][]{{"type.date.full", "type.date.full.format"}, {"type.date.month", "type.date.month.format"}, {"type.date.year", "type.date.year.format"}};

    public OrmLiteDaoFactory(ResourceBundle resourceBundle, Configuration configuration) {
        this.resourceBundle = resourceBundle;
        this.config = new DerbyConfig(configuration);
    }

    @Override
    public Dao getDao(Class clazz) throws SQLException {
        return DaoManager.createDao((ConnectionSource)this.connectionSource, (Class)clazz);
    }

    @Override
    public LocationDao getLocationDAO() throws SQLException {
        return (LocationDao)DaoManager.createDao((ConnectionSource)this.connectionSource, Location.class);
    }

    @Override
    public BurialPlotDao getBurialPlotDAO() throws SQLException {
        return (BurialPlotDao)DaoManager.createDao((ConnectionSource)this.connectionSource, BurialPlot.class);
    }

    @Override
    public DeceasedDao getDeceasedDAO() throws SQLException {
        return (DeceasedDao)DaoManager.createDao((ConnectionSource)this.connectionSource, Deceased.class);
    }

    @Override
    public LocationTypeDao getLocationTypeDAO() throws SQLException {
        return (LocationTypeDao)DaoManager.createDao((ConnectionSource)this.connectionSource, LocationType.class);
    }

    @Override
    public BurialPlotTypeDao getBurialPlotTypeDAO() throws SQLException {
        return (BurialPlotTypeDao)DaoManager.createDao((ConnectionSource)this.connectionSource, BurialPlotType.class);
    }

    @Override
    public DeceasedTypeDao getDeceasedTypeDAO() throws SQLException {
        return (DeceasedTypeDao)DaoManager.createDao((ConnectionSource)this.connectionSource, DeceasedType.class);
    }

    @Override
    public DateTypeDao getDateTypeDao() throws SQLException {
        return (DateTypeDao)DaoManager.createDao((ConnectionSource)this.connectionSource, DateType.class);
    }

    @Override
    public ChangeLogDao getChangeLogDao() throws SQLException {
        return (ChangeLogDao)DaoManager.createDao((ConnectionSource)this.connectionSource, ChangeLog.class);
    }

    @Override
    public void createDatabase() throws SQLException {
        DriverManager.getConnection(this.config.getCreateString());
    }

    @Override
    public void beginConnectionScope() throws SQLException {
        this.connectionSource = new JdbcConnectionSource(this.config.getUrl(), this.config.getUser(), this.config.getPassword());
    }

    @Override
    public void endConnectionScope() throws IOException {
        if (this.connectionSource == null) {
            return;
        }
        this.connectionSource.close();
        try {
            DriverManager.getConnection(this.config.getShutdownString()).close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public <T> T callInTransaction(Callable<T> callable) throws SQLException {
        return (T)TransactionManager.callInTransaction((ConnectionSource)this.connectionSource, callable);
    }

    private <T> List<T> typesToList(CallBack<T> callBack, String[][] libs) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (String[] lib : libs) {
            list.add(callBack.setLib(lib));
        }
        return list;
    }

    @Override
    public void dropTables() throws SQLException {
        LOGGER.info((Object)"Start tables drop");
        this.callInTransaction(() -> {
            this.getDeceasedDAO().dropTable(true);
            this.getBurialPlotDAO().dropTable(true);
            this.getLocationDAO().dropTable(true);
            this.getDeceasedTypeDAO().dropTable(true);
            this.getBurialPlotTypeDAO().dropTable(true);
            this.getLocationTypeDAO().dropTable(true);
            this.getChangeLogDao().dropTable(true);
            return null;
        });
        LOGGER.info((Object)"Tables drop successful");
    }

    @Override
    public void createTables() throws SQLException {
        LOGGER.info((Object)"Start tables creation");
        this.callInTransaction(() -> {
            this.getChangeLogDao().createTable();
            this.getLocationTypeDAO().createTable();
            this.getBurialPlotTypeDAO().createTable();
            this.getDeceasedTypeDAO().createTable();
            this.getLocationTypeDAO().create(this.typesToList(new LocationTypeCallBack(), this.locationTypes));
            this.getBurialPlotTypeDAO().create(this.typesToList(new BurialPlotTypeCallBack(), this.burialPlotTypes));
            this.getDeceasedTypeDAO().create(this.typesToList(new DeceasedTypeCallBack(), this.deceasedTypes));
            this.getDateTypeDao().createTable();
            this.getDateTypeDao().create(this.typesToList(new DateTypeCallBack(), this.dateTypes));
            this.getLocationDAO().createTable();
            this.getBurialPlotDAO().createTable();
            this.getDeceasedDAO().createTable();
            return null;
        });
        LOGGER.info((Object)"Tables creation successful");
    }

    @Override
    public void beforeCreateTables() throws SQLException {
        LOGGER.info((Object)"Before create tables");
        this.callInTransaction(() -> {
            this.getChangeLogDao().initDBAuth(this.config);
            return null;
        });
        LOGGER.info((Object)"Before create tables end");
    }

    @Override
    public void migrateTables() throws SQLException {
        LOGGER.info((Object)"Start DB upgrade");
        this.callInTransaction(() -> {
            int version = this.getChangeLogDao().getLastVersion();
            LOGGER.info((Object)("DB version found : " + version));
            this.getChangeLogDao().migrate(version);
            return null;
        });
        LOGGER.info((Object)"DB upgrade end");
    }

    private final class DateTypeCallBack
    implements CallBack<DateType> {
        private DateTypeCallBack() {
        }

        @Override
        public DateType setLib(String[] data) {
            DateType dateType = new DateType();
            dateType.setLib(OrmLiteDaoFactory.this.resourceBundle.getString(data[0]));
            dateType.setFormat(OrmLiteDaoFactory.this.resourceBundle.getString(data[1]));
            dateType.setCreatedAt(new Date());
            return dateType;
        }
    }

    private final class DeceasedTypeCallBack
    implements CallBack<DeceasedType> {
        private DeceasedTypeCallBack() {
        }

        @Override
        public DeceasedType setLib(String[] data) {
            DeceasedType deceasedType = new DeceasedType();
            deceasedType.setLib(OrmLiteDaoFactory.this.resourceBundle.getString(data[0]));
            deceasedType.setCreatedAt(new Date());
            return deceasedType;
        }
    }

    private final class BurialPlotTypeCallBack
    implements CallBack<BurialPlotType> {
        private BurialPlotTypeCallBack() {
        }

        @Override
        public BurialPlotType setLib(String[] data) {
            BurialPlotType burialPlotType = new BurialPlotType();
            burialPlotType.setLib(OrmLiteDaoFactory.this.resourceBundle.getString(data[0]));
            burialPlotType.setCreatedAt(new Date());
            return burialPlotType;
        }
    }

    private final class LocationTypeCallBack
    implements CallBack<LocationType> {
        private LocationTypeCallBack() {
        }

        @Override
        public LocationType setLib(String[] data) {
            LocationType locationType = new LocationType();
            locationType.setLib(OrmLiteDaoFactory.this.resourceBundle.getString(data[0]));
            locationType.setCreatedAt(new Date());
            return locationType;
        }
    }

    private static interface CallBack<T> {
        public T setLib(String[] var1);
    }
}

