/*
 * Decompiled with CFR 0.152.
 */
package dao;

import com.j256.ormlite.dao.Dao;
import dao.model.BurialPlotDao;
import dao.model.BurialPlotTypeDao;
import dao.model.ChangeLogDao;
import dao.model.DateTypeDao;
import dao.model.DeceasedDao;
import dao.model.DeceasedTypeDao;
import dao.model.LocationDao;
import dao.model.LocationTypeDao;
import dao.ormlite.OrmLiteDaoFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.Configuration;

public abstract class DaoFactory {
    public static final int ORM_LITE = 1;
    private static volatile DaoFactory instance = null;

    public abstract Dao getDao(Class var1) throws SQLException;

    public abstract LocationDao getLocationDAO() throws SQLException;

    public abstract BurialPlotDao getBurialPlotDAO() throws SQLException;

    public abstract DeceasedDao getDeceasedDAO() throws SQLException;

    public abstract LocationTypeDao getLocationTypeDAO() throws SQLException;

    public abstract BurialPlotTypeDao getBurialPlotTypeDAO() throws SQLException;

    public abstract DeceasedTypeDao getDeceasedTypeDAO() throws SQLException;

    public abstract DateTypeDao getDateTypeDao() throws SQLException;

    public abstract ChangeLogDao getChangeLogDao() throws SQLException;

    public abstract void beginConnectionScope() throws SQLException;

    public abstract void endConnectionScope() throws IOException;

    public abstract <T> T callInTransaction(Callable<T> var1) throws SQLException;

    public abstract void createDatabase() throws SQLException;

    public abstract void dropTables() throws SQLException;

    public abstract void createTables() throws SQLException;

    public abstract void migrateTables() throws SQLException;

    public abstract void beforeCreateTables() throws SQLException;

    public static final DaoFactory getDAOFactory(int whichFactory, ResourceBundle resourceBundle, Configuration configuration) {
        switch (whichFactory) {
            case 1: {
                if (instance == null) {
                    instance = new OrmLiteDaoFactory(resourceBundle, configuration);
                }
                return instance;
            }
        }
        return null;
    }
}

