/*
 * Decompiled with CFR 0.152.
 */
package context;

import dao.DaoFactory;
import gui.EventQueueProxy;
import gui.MainFrame;
import gui.components.factory.component.ComponentFactory;
import gui.components.factory.component.I18nComponentFactory;
import gui.components.factory.icon.JIconFactory;
import gui.exceptions.ContextException;
import gui.exceptions.SplashScreenException;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;

public final class Context {
    private final DaoFactory daoFactory;
    private final Configuration configuration = Context.newConfig();
    private final ComponentFactory componentFactory;
    private final ResourceBundle resourceBundle = Context.newResourceBundle(this.configuration);
    private final Subject subject = Context.newSubject();
    private MainFrame mainFrame;
    public static final String CFG_FILE = "config.properties";
    public static final String SHIRO_INI = "classpath:shiro.ini";
    public static final String LOCALE_FR = "fr";
    public static final String LOCALE_EN = "en";
    public static final Locale LOCALE_DEFAULT = Context.getLocale("fr");
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_MANAGER = "manager";
    public static final String ROLE_GUEST = "guest";
    public static final String PERM_ADMINISTRATE = "administrate";
    public static final String PERM_UPDATE = "update";
    public static final String PERM_READ = "read";

    public Context() throws ContextException {
        this.daoFactory = Context.newDaoFactory(this.resourceBundle, this.configuration);
        this.componentFactory = Context.newComponentFactory(this.resourceBundle, this.configuration);
    }

    public static DaoFactory newDaoFactory(ResourceBundle bundle, Configuration config) {
        return DaoFactory.getDAOFactory(1, bundle, config);
    }

    public static ComponentFactory newComponentFactory(ResourceBundle bundle, Configuration config) {
        return new I18nComponentFactory(new JIconFactory(config), bundle);
    }

    public static ResourceBundle newResourceBundle(Configuration config) {
        return ResourceBundle.getBundle("lang", Context.getLocale(config.getString("language")));
    }

    public static Locale getLocale(String param) {
        switch (param) {
            default: {
                return Locale.FRENCH;
            }
            case "en": 
        }
        return Locale.ENGLISH;
    }

    public static File getFile(String path) throws FileNotFoundException {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public static Configuration newConfig() throws ContextException {
        try {
            CombinedConfiguration config = new CombinedConfiguration();
            config.addConfiguration((AbstractConfiguration)new PropertiesConfiguration(Context.class.getClassLoader().getResource(CFG_FILE)));
            config.addConfiguration((AbstractConfiguration)new PropertiesConfiguration(Context.getFile(CFG_FILE)));
            return config;
        }
        catch (FileNotFoundException | ConfigurationException ex) {
            throw new ContextException("Config file error", ex);
        }
    }

    public static Subject newSubject() {
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(SHIRO_INI);
        SecurityManager securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        return SecurityUtils.getSubject();
    }

    public URL getSplashScreenURL() throws FileNotFoundException, MalformedURLException {
        String splashPath = this.configuration.getString("dir.files") + File.separator + this.configuration.getString("file.splash.name");
        return Context.getFile(splashPath).toURI().toURL();
    }

    public void showSplashScreen() throws SplashScreenException {
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash == null) {
            throw new SplashScreenException("SplashScreen.getSplashScreen() returned null");
        }
        try {
            splash.setImageURL(this.getSplashScreenURL());
        }
        catch (FileNotFoundException | MalformedURLException ex) {
            throw new SplashScreenException("Splash screen file error", ex);
        }
        catch (IOException | IllegalStateException | NullPointerException ex) {
            throw new SplashScreenException("Splash screen URL error", ex);
        }
    }

    public EventQueueProxy newEventQueueProxy() {
        return new EventQueueProxy(this.resourceBundle, this.daoFactory);
    }

    public DaoFactory getDaoFactory() {
        return this.daoFactory;
    }

    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }
}

