/*
 * Decompiled with CFR 0.152.
 */
package beans.model;

import beans.model.BurialPlot;
import beans.model.Deceased;
import beans.model.Location;
import beans.model.NodeCallback;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class NodeCache {
    private final Map<Integer, List> burialPlotCache = new HashMap<Integer, List>();
    private final Map<Integer, List> deceasedCache = new HashMap<Integer, List>();
    private NodeCallback nodeCallback;

    public NodeCache(NodeCallback nodeCallback) {
        this.nodeCallback = nodeCallback;
    }

    public void setNodeCallBack(NodeCallback nodeCallBack) {
        this.nodeCallback = nodeCallBack;
    }

    public List<BurialPlot> load(Location location) throws SQLException {
        if (!this.burialPlotCache.containsKey(location.getId())) {
            this.burialPlotCache.put(location.getId(), this.nodeCallback.load(location));
        }
        return this.burialPlotCache.get(location.getId());
    }

    public List<Deceased> load(BurialPlot burialPlot) throws SQLException {
        if (!this.deceasedCache.containsKey(burialPlot.getId())) {
            this.deceasedCache.put(burialPlot.getId(), this.nodeCallback.load(burialPlot));
        }
        return this.deceasedCache.get(burialPlot.getId());
    }

    public void clear() {
        this.burialPlotCache.clear();
        this.deceasedCache.clear();
    }
}

