/*
 * Decompiled with CFR 0.152.
 */
package beans.model;

import beans.model.AbstractModel;
import beans.model.BurialPlot;
import beans.model.BurialPlotType;
import beans.model.DataNode;
import beans.model.LocationType;
import beans.model.NodeCache;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import context.Context;
import dao.ormlite.model.LocationOrmLiteDao;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.forms.beans.model.BurialPlotForm;
import gui.dialogs.forms.beans.model.LocationForm;
import gui.dialogs.forms.beans.validators.annotations.BoundedLenght;
import gui.dialogs.forms.beans.validators.annotations.InDatabase;
import gui.dialogs.forms.beans.validators.annotations.NotNull;
import gui.panels.InfoPanel;
import gui.panels.TreePanel;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.tree.TreePath;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.subject.Subject;

@DatabaseTable(tableName="LOCATION", daoClass=LocationOrmLiteDao.class)
public class Location
extends AbstractModel
implements DataNode {
    @NotNull(messageKey="location.dxf.null")
    @BoundedLenght(min=1, max=16, messageKey="location.dxf.length")
    @DatabaseField(columnName="DXF_HANDLE", width=16, canBeNull=false)
    private String dxfHandle;
    @NotNull(messageKey="location.reference.null")
    @BoundedLenght(min=1, max=50, messageKey="location.reference.length")
    @InDatabase(messageKey="location.reference.in_db", not=true, column="REFERENCE")
    @DatabaseField(columnName="REFERENCE", width=50, canBeNull=false, unique=true)
    private String reference;
    @BoundedLenght(min=1, max=5000, messageKey="location.comments.bounds")
    @DatabaseField(columnName="COMMENTS", width=5000)
    private String comments;
    @NotNull(messageKey="location.type.null")
    @InDatabase(messageKey="location.type.not_in_db", foreign=true)
    @DatabaseField(columnName="LOCATION_TYPE_ID", foreign=true, canBeNull=false, foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT LOCATION_TYPE_ID REFERENCES LOCATION_TYPE(ID)")
    private LocationType locationType;
    @ForeignCollectionField(columnName="LOCATION_ID")
    private Collection<BurialPlot> burialPlots;
    public static final int PAR_DXF_HANDLE_MIN = 1;
    public static final int PAR_DXF_HANDLE_MAX = 16;
    public static final int PAR_REFERENCE_MIN = 1;
    public static final int PAR_REFERENCE_MAX = 50;
    public static final int PAR_COMMENTS_MIN = 1;
    public static final int PAR_COMMENTS_MAX = 5000;
    public static final String PROP_DXF_HANDLE = "dxfHandle";
    public static final String PROP_REFERENCE = "reference";
    public static final String PROP_COMMENTS = "comments";
    public static final String PROP_LOCATION_TYPE = "locationType";
    public static final String DB_TABLE = "LOCATION";
    public static final String DB_DXF_HANDLE = "DXF_HANDLE";
    public static final String DB_REFERENCE = "REFERENCE";
    public static final String DB_COMMENTS = "COMMENTS";
    public static final String DB_LOCATION_TYPE_ID = "LOCATION_TYPE_ID";
    public static final String DB_FK_LOCATION_TYPE_ID = "LOCATION_TYPE_ID";
    public static final String DB_LOCATION_TYPE_COL_DEF = "INTEGER NOT NULL CONSTRAINT LOCATION_TYPE_ID REFERENCES LOCATION_TYPE(ID)";

    public String getDxfHandle() {
        return this.dxfHandle;
    }

    public void setDxfHandle(String dxfHandle) {
        String oldDxfHandle = this.dxfHandle;
        this.dxfHandle = dxfHandle;
        this.getSupport().firePropertyChange(PROP_DXF_HANDLE, oldDxfHandle, dxfHandle);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        String oldReference = this.reference;
        this.reference = reference;
        this.getSupport().firePropertyChange(PROP_REFERENCE, oldReference, reference);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        String oldComments = this.comments;
        this.comments = comments;
        this.getSupport().firePropertyChange(PROP_COMMENTS, oldComments, comments);
    }

    public LocationType getLocationType() {
        return this.locationType;
    }

    public void setLocationType(LocationType locationType) {
        LocationType oldLocationType = this.locationType;
        this.locationType = locationType;
        this.getSupport().firePropertyChange(PROP_LOCATION_TYPE, oldLocationType, locationType);
    }

    public Collection<BurialPlot> getBurialPlots() {
        return this.burialPlots;
    }

    public void setBurialPlots(Collection<BurialPlot> burialPlots) {
        this.burialPlots = burialPlots;
    }

    public String toString() {
        return "[ID " + this.getId() + "] " + (this.isUnknown() ? "UNKNOWN" : this.reference);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location type = (Location)obj;
        return Objects.equals(this.getId(), type.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public boolean getCenterStatus(Subject subject) {
        return true;
    }

    @Override
    public boolean getCreateStatus(Subject subject) {
        return subject.isPermitted("update");
    }

    @Override
    public boolean getUpdateStatus(Subject subject) {
        return subject.isPermitted("administrate");
    }

    @Override
    public String getCenterLabel(ResourceBundle resourceBundle) {
        return resourceBundle.getString("tree.tip.center.location");
    }

    @Override
    public String getIconFileName() {
        return "marker.png";
    }

    @Override
    public Location getLocationNode(TreePath path) {
        return this;
    }

    @Override
    public List getChildren(NodeCache cache) throws SQLException {
        return cache.load(this);
    }

    @Override
    public List getPaginatedChildren(NodeCache cache, int page, int perPage) throws SQLException {
        return this.getChildren(cache);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractModelForm getCreateForm(Context context) throws SQLException {
        BurialPlot burialPlot = new BurialPlot();
        burialPlot.setLocation(this);
        BurialPlotType type = (BurialPlotType)context.getDaoFactory().getBurialPlotTypeDAO().queryBuilder().queryForFirst();
        burialPlot.setBurialPlotType(type);
        return new BurialPlotForm(context, "form.burialplot.create", burialPlot);
    }

    public Location cloneBean() throws CloneNotSupportedException {
        try {
            return (Location)BeanUtils.cloneBean((Object)this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    @Override
    public AbstractModelForm getUpdateForm(Context context) throws SQLException, CloneNotSupportedException {
        return new LocationForm(context, "form.location.update", this.cloneBean());
    }

    @Override
    public void displayData(InfoPanel panel) throws SQLException {
        panel.setData(this);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return this.reference == null;
    }

    @Override
    public String getDisplayName() {
        return this.reference;
    }

    @Override
    public void displayData(TreePanel panel) throws SQLException {
        panel.findBy(this);
    }
}

