/*
 * Decompiled with CFR 0.152.
 */
package beans.model;

import beans.model.AbstractModel;
import beans.model.BurialPlot;
import beans.model.DataNode;
import beans.model.DateType;
import beans.model.DeceasedType;
import beans.model.Location;
import beans.model.NodeCache;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import context.Context;
import dao.ormlite.model.DeceasedOrmLiteDao;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.forms.beans.model.DeceasedForm;
import gui.dialogs.forms.beans.validators.annotations.BoundedLenght;
import gui.dialogs.forms.beans.validators.annotations.InDatabase;
import gui.dialogs.forms.beans.validators.annotations.NotNull;
import gui.panels.InfoPanel;
import gui.panels.TreePanel;
import gui.utils.DateUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.tree.TreePath;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.subject.Subject;

@DatabaseTable(tableName="DECEASED", daoClass=DeceasedOrmLiteDao.class)
public class Deceased
extends AbstractModel
implements DataNode {
    @BoundedLenght(min=1, max=100, messageKey="deceased.first_name.bounds")
    @DatabaseField(columnName="FIRST_NAME", width=100)
    private String firstName;
    @BoundedLenght(min=1, max=100, messageKey="deceased.birth_name.bounds")
    @DatabaseField(columnName="BIRTH_NAME", width=100)
    private String birthName;
    @BoundedLenght(min=1, max=50, messageKey="deceased.nick_name.bounds")
    @DatabaseField(columnName="NICK_NAME", width=50)
    private String nickName;
    @BoundedLenght(min=1, max=100, messageKey="deceased.last_name.bounds")
    @DatabaseField(columnName="LAST_NAME", width=100)
    private String lastName;
    @DatabaseField(columnName="BIRTH_DATE")
    private Date birthDate;
    @DatabaseField(columnName="DEATH_DATE")
    private Date deathDate;
    @NotNull(messageKey="deceased.birth_date_type.null")
    @InDatabase(messageKey="deceased.date_type.not_in_db", foreign=true)
    @DatabaseField(columnName="BIRTH_DATE_TYPE_ID", foreign=true, canBeNull=false, defaultValue="1", foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_BIRTH_DATE_TYPE_ID REFERENCES DATE_TYPE(ID)")
    private DateType birthDateType;
    @NotNull(messageKey="deceased.death_date_type.null")
    @InDatabase(messageKey="deceased.date_type.not_in_db", foreign=true)
    @DatabaseField(columnName="DEATH_DATE_TYPE_ID", foreign=true, canBeNull=false, defaultValue="1", foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_DEATH_DATE_TYPE_ID REFERENCES DATE_TYPE(ID)")
    private DateType deathDateType;
    @BoundedLenght(min=1, max=5000, messageKey="deceased.comments.bounds")
    @DatabaseField(columnName="COMMENTS", width=5000)
    private String comments;
    @NotNull(messageKey="deceased.burialplot.null")
    @InDatabase(messageKey="deceased.burialplot.not_in_db", foreign=true)
    @DatabaseField(columnName="BURIAL_PLOT_ID", foreign=true, canBeNull=false, foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_BURIAL_PLOT_ID REFERENCES BURIAL_PLOT(ID)")
    private BurialPlot burialPlot;
    @NotNull(messageKey="deceased.type.null")
    @InDatabase(messageKey="deceased.type.not_in_db", foreign=true)
    @DatabaseField(columnName="DECEASED_TYPE_ID", foreign=true, canBeNull=false, foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_DECEASED_TYPE_ID REFERENCES DECEASED_TYPE(ID)")
    private DeceasedType deceasedType;
    public static final int PAR_FIRST_NAME_MIN = 1;
    public static final int PAR_FIRST_NAME_MAX = 100;
    public static final int PAR_BIRTH_NAME_MIN = 1;
    public static final int PAR_BIRTH_NAME_MAX = 100;
    public static final int PAR_NICK_NAME_MIN = 1;
    public static final int PAR_NICK_NAME_MAX = 50;
    public static final int PAR_LAST_NAME_MIN = 1;
    public static final int PAR_LAST_NAME_MAX = 100;
    public static final int PAR_COMMENTS_MIN = 1;
    public static final int PAR_COMMENTS_MAX = 5000;
    public static final String PROP_FIRST_NAME = "firstName";
    public static final String PROP_BIRTH_NAME = "birthName";
    public static final String PROP_NICK_NAME = "nickName";
    public static final String PROP_LAST_NAME = "lastName";
    public static final String PROP_BIRTH_DATE = "birthDate";
    public static final String PROP_DEATH_DATE = "deathDate";
    public static final String PROP_BIRTH_DATE_TYPE = "birthDateType";
    public static final String PROP_DEATH_DATE_TYPE = "deathDateType";
    public static final String PROP_COMMENTS = "comments";
    public static final String PROP_BURIAL_PLOT = "burialPlot";
    public static final String PROP_DECEASED_TYPE = "deceasedType";
    public static final String DB_TABLE = "DECEASED";
    public static final String DB_FIRST_NAME = "FIRST_NAME";
    public static final String DB_BIRTH_NAME = "BIRTH_NAME";
    public static final String DB_NICK_NAME = "NICK_NAME";
    public static final String DB_LAST_NAME = "LAST_NAME";
    public static final String DB_BIRTH_DATE = "BIRTH_DATE";
    public static final String DB_DEATH_DATE = "DEATH_DATE";
    public static final String DB_BIRTH_DATE_TYPE_ID = "BIRTH_DATE_TYPE_ID";
    public static final String DB_DEATH_DATE_TYPE_ID = "DEATH_DATE_TYPE_ID";
    public static final String DB_COMMENTS = "COMMENTS";
    public static final String DB_BURIAL_PLOT_ID = "BURIAL_PLOT_ID";
    public static final String DB_FK_BURIAL_PLOT_ID = "FK_BURIAL_PLOT_ID";
    public static final String DB_DECEASED_TYPE_ID = "DECEASED_TYPE_ID";
    public static final String DB_FK_DECEASED_TYPE_ID = "FK_DECEASED_TYPE_ID";
    public static final String DB_FK_BIRTH_DATE_TYPE_ID = "FK_BIRTH_DATE_TYPE_ID";
    public static final String DB_FK_DEATH_DATE_TYPE_ID = "FK_DEATH_DATE_TYPE_ID";
    public static final String DB_BURIAL_PLOT_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_BURIAL_PLOT_ID REFERENCES BURIAL_PLOT(ID)";
    public static final String DB_DECEASED_TYPE_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_DECEASED_TYPE_ID REFERENCES DECEASED_TYPE(ID)";
    public static final String DB_BIRTH_DATE_TYPE_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_BIRTH_DATE_TYPE_ID REFERENCES DATE_TYPE(ID)";
    public static final String DB_DEATH_DATE_TYPE_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_DEATH_DATE_TYPE_ID REFERENCES DATE_TYPE(ID)";

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        String oldFirstName = this.firstName;
        this.firstName = firstName;
        this.getSupport().firePropertyChange(PROP_FIRST_NAME, oldFirstName, firstName);
    }

    public String getBirthName() {
        return this.birthName;
    }

    public void setBirthName(String birthName) {
        String oldBirthName = this.birthName;
        this.birthName = birthName;
        this.getSupport().firePropertyChange(PROP_BIRTH_NAME, oldBirthName, birthName);
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        String oldNickName = this.nickName;
        this.nickName = nickName;
        this.getSupport().firePropertyChange(PROP_NICK_NAME, oldNickName, nickName);
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        String oldLastName = this.lastName;
        this.lastName = lastName;
        this.getSupport().firePropertyChange(PROP_LAST_NAME, oldLastName, lastName);
    }

    public String getFullName() {
        if (this.firstName == null && this.lastName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.firstName != null) {
            sb.append(this.firstName);
        }
        if (this.lastName != null) {
            if (this.firstName != null) {
                sb.append(" ");
            }
            sb.append(this.lastName);
        }
        return sb.toString();
    }

    public Date getBirthDate() {
        return DateUtils.copy(this.birthDate);
    }

    public void setBirthDate(Date birthDate) {
        Date oldBirthDate = this.birthDate;
        this.birthDate = DateUtils.copy(birthDate);
        this.getSupport().firePropertyChange(PROP_BIRTH_DATE, oldBirthDate, birthDate);
    }

    public Date getDeathDate() {
        return DateUtils.copy(this.deathDate);
    }

    public void setDeathDate(Date deathDate) {
        Date oldDeathDate = this.deathDate;
        this.deathDate = DateUtils.copy(deathDate);
        this.getSupport().firePropertyChange(PROP_DEATH_DATE, oldDeathDate, deathDate);
    }

    public DateType getBirthDateType() {
        return this.birthDateType;
    }

    public void setBirthDateType(DateType birthDateType) {
        DateType oldBirthDateType = this.birthDateType;
        this.birthDateType = birthDateType;
        this.getSupport().firePropertyChange(PROP_BIRTH_DATE_TYPE, oldBirthDateType, birthDateType);
    }

    public DateType getDeathDateType() {
        return this.deathDateType;
    }

    public void setDeathDateType(DateType deathDateType) {
        DateType oldDeathDateType = this.deathDateType;
        this.deathDateType = deathDateType;
        this.getSupport().firePropertyChange(PROP_DEATH_DATE_TYPE, oldDeathDateType, deathDateType);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        String oldComments = this.comments;
        this.comments = comments;
        this.getSupport().firePropertyChange(PROP_COMMENTS, oldComments, comments);
    }

    public BurialPlot getBurialPlot() {
        return this.burialPlot;
    }

    public void setBurialPlot(BurialPlot burialPlot) {
        BurialPlot oldBurialPlot = this.burialPlot;
        this.burialPlot = burialPlot;
        this.getSupport().firePropertyChange(PROP_BURIAL_PLOT, oldBurialPlot, burialPlot);
    }

    public DeceasedType getDeceasedType() {
        return this.deceasedType;
    }

    public void setDeceasedType(DeceasedType deceasedType) {
        DeceasedType oldDeceasedType = this.deceasedType;
        this.deceasedType = deceasedType;
        this.getSupport().firePropertyChange(PROP_DECEASED_TYPE, oldDeceasedType, deceasedType);
    }

    public String toString() {
        return "[ID " + this.getId() + "] " + (this.isUnknown() ? "UNKNOWN" : this.getFullName());
    }

    public Deceased cloneBean() throws CloneNotSupportedException {
        try {
            return (Deceased)BeanUtils.cloneBean((Object)this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Deceased)) {
            return false;
        }
        Deceased type = (Deceased)obj;
        return Objects.equals(this.getId(), type.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public boolean getCenterStatus(Subject subject) {
        return true;
    }

    @Override
    public boolean getCreateStatus(Subject subject) {
        return false;
    }

    @Override
    public boolean getUpdateStatus(Subject subject) {
        return subject.isPermitted("update");
    }

    @Override
    public String getCenterLabel(ResourceBundle resourceBundle) {
        return resourceBundle.getString("tree.tip.center.deceased");
    }

    @Override
    public String getIconFileName() {
        return "user.png";
    }

    @Override
    public Location getLocationNode(TreePath path) {
        return (Location)path.getParentPath().getParentPath().getLastPathComponent();
    }

    @Override
    public List getChildren(NodeCache cache) throws SQLException {
        return null;
    }

    @Override
    public List getPaginatedChildren(NodeCache cache, int page, int perPage) throws SQLException {
        return this.getChildren(cache);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public AbstractModelForm getCreateForm(Context context) throws SQLException {
        return null;
    }

    @Override
    public AbstractModelForm getUpdateForm(Context context) throws SQLException, CloneNotSupportedException {
        return new DeceasedForm(context, "form.deceased.update", this.cloneBean());
    }

    @Override
    public void displayData(InfoPanel panel) throws SQLException {
        panel.setData(this);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return this.firstName == null && this.lastName == null;
    }

    @Override
    public String getDisplayName() {
        return this.getFullName();
    }

    @Override
    public void displayData(TreePanel panel) throws SQLException {
        panel.findBy(this);
    }
}

