/*
 * Decompiled with CFR 0.152.
 */
package beans.model;

import beans.model.AbstractModel;
import beans.model.BurialPlotType;
import beans.model.DataNode;
import beans.model.DateType;
import beans.model.Deceased;
import beans.model.DeceasedType;
import beans.model.Location;
import beans.model.NodeCache;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import context.Context;
import dao.ormlite.model.BurialPlotOrmLiteDao;
import gui.dialogs.forms.beans.model.AbstractModelForm;
import gui.dialogs.forms.beans.model.BurialPlotForm;
import gui.dialogs.forms.beans.model.DeceasedForm;
import gui.dialogs.forms.beans.validators.annotations.BoundedLenght;
import gui.dialogs.forms.beans.validators.annotations.BoundedValue;
import gui.dialogs.forms.beans.validators.annotations.InDatabase;
import gui.dialogs.forms.beans.validators.annotations.NotNull;
import gui.panels.InfoPanel;
import gui.panels.TreePanel;
import gui.utils.DateUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.tree.TreePath;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.subject.Subject;

@DatabaseTable(tableName="BURIAL_PLOT", daoClass=BurialPlotOrmLiteDao.class)
public class BurialPlot
extends AbstractModel
implements DataNode {
    @BoundedLenght(min=3, max=100, messageKey="burialplot.name.length")
    @DatabaseField(columnName="NAME", width=100)
    private String name;
    @BoundedLenght(min=1, max=50, messageKey="burialplot.reference.length")
    @InDatabase(messageKey="burialplot.reference.in_db", not=true, column="REFERENCE")
    @DatabaseField(columnName="REFERENCE", width=50, canBeNull=true, unique=true)
    private String reference;
    @BoundedValue(min=1, max=50, messageKey="burialplot.capacity.length")
    @DatabaseField(columnName="CAPACITY")
    private Integer capacity;
    @DatabaseField(columnName="SELL_DATE")
    private Date sellDate;
    @BoundedValue(min=1, max=100, messageKey="burialplot.duration.bounds")
    @DatabaseField(columnName="DURATION")
    private Integer duration;
    @BoundedLenght(min=1, max=5000, messageKey="burialplot.comments.bounds")
    @DatabaseField(columnName="COMMENTS", width=5000)
    private String comments;
    @NotNull(messageKey="burialplot.location.null")
    @InDatabase(messageKey="burialplot.location.not_in_db", foreign=true)
    @DatabaseField(columnName="LOCATION_ID", foreign=true, canBeNull=false, foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_LOCATION_ID REFERENCES LOCATION(ID)")
    private Location location;
    @NotNull(messageKey="burialplot.type.null")
    @InDatabase(messageKey="burialplot.type.not_in_db", foreign=true)
    @DatabaseField(columnName="BURIAL_PLOT_TYPE_ID", foreign=true, canBeNull=false, foreignAutoRefresh=true, columnDefinition="INTEGER NOT NULL CONSTRAINT FK_BURIAL_PLOT_TYPE_ID REFERENCES BURIAL_PLOT_TYPE(ID)")
    private BurialPlotType burialPlotType;
    @ForeignCollectionField(columnName="BURIAL_PLOT_ID")
    private Collection<Deceased> deceased;
    public static final int PAR_NAME_MIN = 3;
    public static final int PAR_NAME_MAX = 100;
    public static final int PAR_REFERENCE_MIN = 1;
    public static final int PAR_REFERENCE_MAX = 50;
    public static final int PAR_CAPACITY_MIN = 1;
    public static final int PAR_CAPACITY_MAX = 50;
    public static final int PAR_CAPACITY_STEP = 1;
    public static final int PAR_DURATION_MIN = 1;
    public static final int PAR_DURATION_MAX = 100;
    public static final int PAR_DURATION_STEP = 1;
    public static final int PAR_COMMENTS_MIN = 1;
    public static final int PAR_COMMENTS_MAX = 5000;
    public static final String PROP_NAME = "name";
    public static final String PROP_REFERENCE = "reference";
    public static final String PROP_CAPACITY = "capacity";
    public static final String PROP_DURATION = "duration";
    public static final String PROP_SELL_DATE = "sellDate";
    public static final String PROP_COMMENTS = "comments";
    public static final String PROP_LOCATION = "location";
    public static final String PROP_BURIAL_PLOT_TYPE = "burialPlotType";
    public static final String DB_TABLE = "BURIAL_PLOT";
    public static final String DB_NAME = "NAME";
    public static final String DB_REFERENCE = "REFERENCE";
    public static final String DB_CAPACITY = "CAPACITY";
    public static final String DB_DURATION = "DURATION";
    public static final String DB_SELL_DATE = "SELL_DATE";
    public static final String DB_COMMENTS = "COMMENTS";
    public static final String DB_LOCATION_ID = "LOCATION_ID";
    public static final String DB_FK_LOCATION_ID = "FK_LOCATION_ID";
    public static final String DB_BURIAL_PLOT_TYPE_ID = "BURIAL_PLOT_TYPE_ID";
    public static final String DB_FK_BURIAL_PLOT_TYPE_ID = "FK_BURIAL_PLOT_TYPE_ID";
    public static final String DB_LOCATION_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_LOCATION_ID REFERENCES LOCATION(ID)";
    public static final String DB_BURIAL_PLOT_TYPE_COL_DEF = "INTEGER NOT NULL CONSTRAINT FK_BURIAL_PLOT_TYPE_ID REFERENCES BURIAL_PLOT_TYPE(ID)";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.getSupport().firePropertyChange(PROP_NAME, oldName, name);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        String oldReference = this.reference;
        this.reference = reference;
        this.getSupport().firePropertyChange(PROP_REFERENCE, oldReference, reference);
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        Integer oldCapacity = this.capacity;
        this.capacity = capacity;
        this.getSupport().firePropertyChange(PROP_CAPACITY, oldCapacity, capacity);
    }

    public Date getSellDate() {
        return DateUtils.copy(this.sellDate);
    }

    public void setSellDate(Date sellDate) {
        Date oldDate = this.sellDate;
        this.sellDate = DateUtils.copy(sellDate);
        this.getSupport().firePropertyChange(PROP_SELL_DATE, oldDate, sellDate);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        Integer oldDuration = this.duration;
        this.duration = duration;
        this.getSupport().firePropertyChange(PROP_DURATION, oldDuration, duration);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        String oldComments = this.comments;
        this.comments = comments;
        this.getSupport().firePropertyChange(PROP_COMMENTS, oldComments, comments);
    }

    public Date getEndDate() {
        if (this.sellDate == null || this.duration == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.sellDate);
        calendar.add(1, this.duration);
        return new Date(calendar.getTimeInMillis());
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        Location oldLocation = this.location;
        this.location = location;
        this.getSupport().firePropertyChange(PROP_LOCATION, oldLocation, location);
    }

    public BurialPlotType getBurialPlotType() {
        return this.burialPlotType;
    }

    public void setBurialPlotType(BurialPlotType burialPlotType) {
        BurialPlotType oldBurialPlotType = this.burialPlotType;
        this.burialPlotType = burialPlotType;
        this.getSupport().firePropertyChange(PROP_BURIAL_PLOT_TYPE, oldBurialPlotType, burialPlotType);
    }

    public Collection<Deceased> getDeceaseds() {
        return this.deceased;
    }

    public void setDeceased(Collection<Deceased> deceased) {
        this.deceased = deceased;
    }

    public String toString() {
        return "[ID " + this.getId() + "] " + (this.isUnknown() ? "UNKNOWN" : this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BurialPlot)) {
            return false;
        }
        BurialPlot type = (BurialPlot)obj;
        return Objects.equals(this.getId(), type.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public boolean getCenterStatus(Subject subject) {
        return true;
    }

    @Override
    public boolean getCreateStatus(Subject subject) {
        return subject.isPermitted("update");
    }

    @Override
    public boolean getUpdateStatus(Subject subject) {
        return subject.isPermitted("update");
    }

    @Override
    public String getCenterLabel(ResourceBundle resourceBundle) {
        return resourceBundle.getString("tree.tip.center.burialplot");
    }

    @Override
    public String getIconFileName() {
        return "headstone.png";
    }

    @Override
    public Location getLocationNode(TreePath path) {
        return (Location)path.getParentPath().getLastPathComponent();
    }

    @Override
    public List getChildren(NodeCache cache) throws SQLException {
        return cache.load(this);
    }

    @Override
    public List getPaginatedChildren(NodeCache cache, int page, int perPage) throws SQLException {
        return this.getChildren(cache);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractModelForm getCreateForm(Context context) throws SQLException {
        Deceased deceased = new Deceased();
        deceased.setBurialPlot(this);
        DeceasedType type = (DeceasedType)context.getDaoFactory().getDeceasedTypeDAO().queryBuilder().queryForFirst();
        deceased.setDeceasedType(type);
        deceased.setBirthDateType((DateType)context.getDaoFactory().getDateTypeDao().queryForId(1));
        deceased.setDeathDateType((DateType)context.getDaoFactory().getDateTypeDao().queryForId(1));
        return new DeceasedForm(context, "form.deceased.create", deceased);
    }

    public BurialPlot cloneBean() throws CloneNotSupportedException {
        try {
            return (BurialPlot)BeanUtils.cloneBean((Object)this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    @Override
    public AbstractModelForm getUpdateForm(Context context) throws SQLException, CloneNotSupportedException {
        return new BurialPlotForm(context, "form.burialplot.update", this.cloneBean());
    }

    @Override
    public void displayData(InfoPanel panel) throws SQLException {
        panel.setData(this);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return this.name == null;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void displayData(TreePanel panel) throws SQLException {
        panel.findBy(this);
    }
}

