/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.layout;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableLayout;
import bibliothek.gui.dock.common.intern.layout.ReplacementDockFactory;
import bibliothek.gui.dock.frontend.DefaultLayoutChangeStrategy;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLayoutChangeStrategy
extends DefaultLayoutChangeStrategy {
    private CControl control;
    private static final String REPLACEMENT_FACTORY_ID = PredefinedDockSituation.convertFactoryID("dock.common.replacement_factory");

    public CLayoutChangeStrategy(CControl control) {
        this.control = control;
    }

    @Override
    protected PredefinedDockSituation createSituation(DockFrontendInternals frontend, boolean entry, boolean onSetLayout) {
        PredefinedDockSituation situation = super.createSituation(frontend, entry, onSetLayout);
        if (onSetLayout) {
            situation.add(new ReplacementDockFactory());
        }
        situation.setPlaceholderStrategy(this.control.getProperty(PlaceholderStrategy.PLACEHOLDER_STRATEGY));
        return situation;
    }

    @Override
    protected boolean shouldPredefine(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable() instanceof SingleCDockable;
        }
        return true;
    }

    @Override
    protected Set<Dockable> estimateVisible(DockFrontendInternals frontend, DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            HashSet<Dockable> allDockables = new HashSet<Dockable>();
            for (DockFrontend.DockInfo info : frontend.getDockables()) {
                Dockable dockable = info.getDockable();
                if (dockable == null) continue;
                allDockables.add(dockable);
            }
            for (MultipleCDockable dockable : this.control.getRegister().getMultipleDockables()) {
                allDockables.add(dockable.intern());
            }
            PredefinedDockSituation predefined = (PredefinedDockSituation)situation;
            Set<Dockable> visible = predefined.listVisible(allDockables, layout);
            this.findVisible(visible, layout);
            return visible;
        }
        return null;
    }

    @Override
    protected Collection<Dockable> getClosingDockables(DockFrontendInternals frontend, Set<Dockable> visible) {
        Collection<Dockable> result = super.getClosingDockables(frontend, visible);
        for (MultipleCDockable dockable : this.control.getRegister().getMultipleDockables()) {
            CommonDockable intern = dockable.intern();
            if (visible.contains(intern)) continue;
            result.add(intern);
        }
        return result;
    }

    private void findVisible(Set<Dockable> visible, DockLayoutComposition layout) {
        DockLayout<?> data;
        DockLayoutInfo info = layout.getLayout();
        if (info != null && (data = info.getDataLayout()) != null && REPLACEMENT_FACTORY_ID.equals(data.getFactoryID())) {
            CDockable dockable = (CDockable)data.getData();
            visible.add(dockable.intern());
        }
        for (DockLayoutComposition child : layout.getChildren()) {
            this.findVisible(visible, child);
        }
    }

    protected DockLayoutComposition replaceMultipleDockables(DockFrontendInternals frontend, CSettingAccess setting, DockLayoutComposition composition) {
        MultipleCDockable match;
        DockLayout<?> layout;
        if (composition == null) {
            return null;
        }
        DockLayoutInfo info = composition.getLayout();
        if (info != null && (layout = info.getDataLayout()) != null && (match = setting.findMatch(layout)) != null) {
            DockLayout<MultipleCDockable> newLayout = new DockLayout<MultipleCDockable>(REPLACEMENT_FACTORY_ID, match);
            DockLayoutInfo newInfo = new DockLayoutInfo(newLayout);
            newInfo.setLocation(info.getLocation());
            info = newInfo;
        }
        List<DockLayoutComposition> oldChildren = composition.getChildren();
        ArrayList<DockLayoutComposition> newChildren = new ArrayList<DockLayoutComposition>(oldChildren.size());
        for (DockLayoutComposition child : oldChildren) {
            newChildren.add(this.replaceMultipleDockables(frontend, setting, child));
        }
        return new DockLayoutComposition(info, composition.getAdjacent(), newChildren, composition.isIgnoreChildren());
    }

    @Override
    protected DefaultLayoutChangeStrategy.SettingAccess createAccess(DockFrontendInternals frontend, Setting setting) {
        return new CSettingAccess(frontend, setting);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CSettingAccess
    extends DefaultLayoutChangeStrategy.SettingAccess {
        private DockFrontendInternals frontend;
        private Map<String, DockLayoutComposition> modifiedRoots;
        private Map<String, MultipleCDockableFactory<?, ?>> factories;
        private Map<String, List<MultipleCDockable>> remainingDockables;

        public CSettingAccess(DockFrontendInternals frontend, Setting setting) {
            super(CLayoutChangeStrategy.this, setting);
            this.modifiedRoots = new HashMap<String, DockLayoutComposition>();
            this.frontend = frontend;
            Map<String, MultipleCDockableFactory<?, ?>> factories = CLayoutChangeStrategy.this.control.getRegister().getFactories();
            this.factories = new HashMap();
            for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : factories.entrySet()) {
                this.factories.put(PredefinedDockSituation.convertFactoryID(entry.getKey()), entry.getValue());
            }
            this.remainingDockables = new HashMap<String, List<MultipleCDockable>>();
            block1: for (MultipleCDockable dockable : CLayoutChangeStrategy.this.control.getRegister().getMultipleDockables()) {
                for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : factories.entrySet()) {
                    if (entry.getValue() != dockable.getFactory()) continue;
                    String key = PredefinedDockSituation.convertFactoryID(entry.getKey());
                    List<MultipleCDockable> list = this.remainingDockables.get(key);
                    if (list == null) {
                        list = new LinkedList<MultipleCDockable>();
                        this.remainingDockables.put(key, list);
                    }
                    list.add(dockable);
                    continue block1;
                }
            }
        }

        public MultipleCDockable findMatch(DockLayout<?> layout) {
            String factoryId = layout.getFactoryID();
            Object data = layout.getData();
            if (data instanceof CommonMultipleDockableLayout) {
                List<MultipleCDockable> list;
                MultipleCDockableLayout multipleLayout = ((CommonMultipleDockableLayout)data).getLayout();
                MultipleCDockableFactory<?, ?> factory = this.factories.get(factoryId);
                if (factory != null && (list = this.remainingDockables.get(factoryId)) != null) {
                    Iterator<MultipleCDockable> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        MultipleCDockable next = iterator.next();
                        if (!factory.match(next, multipleLayout)) continue;
                        iterator.remove();
                        if (list.isEmpty()) {
                            this.remainingDockables.remove(factoryId);
                        }
                        return next;
                    }
                }
            }
            return null;
        }

        @Override
        public DockLayoutComposition getRoot(String root) {
            DockLayoutComposition result = this.modifiedRoots.get(root);
            if (result == null) {
                result = CLayoutChangeStrategy.this.replaceMultipleDockables(this.frontend, this, super.getRoot(root));
                this.modifiedRoots.put(root, result);
            }
            return result;
        }
    }
}

