/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.FilteredDockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.action.StationChildrenActionSource;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentFilter;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonContentValue;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.Condition;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class BasicButtonDockTitle
extends AbstractDockTitle {
    protected final int KNOB_SIZE = 10;
    private boolean mousePressed = false;
    private boolean selected = false;
    protected ButtonContentValue behavior;
    private PropertyValue<ButtonContentFilter> connector = new PropertyValue<ButtonContentFilter>(FlapDockStation.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter oldValue, ButtonContentFilter newValue) {
            if (BasicButtonDockTitle.this.behavior != null) {
                BasicButtonDockTitle.this.updateActionSource(true);
            }
        }
    };
    private boolean showChildren = false;
    private boolean showActions = false;
    private boolean filterActions = false;
    private TitleColor activeColor = new BasicTitleColor("title.flap.active", null);
    private TitleColor activeTextColor = new BasicTitleColor("title.flap.active.text", null);
    private TitleColor inactiveColor = new BasicTitleColor("title.flap.inactive", null);
    private TitleColor inactiveTextColor = new BasicTitleColor("title.flap.inactive.text", null);
    private TitleColor selectedColor = new BasicTitleColor("title.flap.selected", null);
    private TitleColor selectedTextColor = new BasicTitleColor("title.flap.selected.text", null);
    private TitleColor knobActiveHighlightColor = new BasicTitleColor("title.flap.active.knob.highlight", null);
    private TitleColor knobActiveShadowColor = new BasicTitleColor("title.flap.active.knob.shadow", null);
    private TitleColor knobInactiveHighlightColor = new BasicTitleColor("title.flap.inactive.knob.highlight", null);
    private TitleColor knobInactiveShadowColor = new BasicTitleColor("title.flap.inactive.knob.shadow", null);
    private TitleColor knobSelectedHighlightColor = new BasicTitleColor("title.flap.selected.knob.highlight", null);
    private TitleColor knobSelectedShadowColor = new BasicTitleColor("title.flap.selected.knob.shadow", null);
    private MultiDockActionSource allActionsSource = new MultiDockActionSource(new DockActionSource[0]);

    public BasicButtonDockTitle(Dockable dockable, DockTitleVersion origin) {
        this.behavior = new ButtonContentValue(new ButtonContent(ButtonContent.TRUE, ButtonContent.TRUE, ButtonContent.IF_DOCKABLE, ButtonContent.IF_STATION, ButtonContent.TRUE, ButtonContent.TRUE)){

            protected void propertyChanged() {
                BasicButtonDockTitle.this.updateContent();
            }
        };
        this.init(dockable, origin, false);
        this.changeBorder();
        this.addMouseInputListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                BasicButtonDockTitle.this.mousePressed = (e.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }

            public void mouseReleased(MouseEvent e) {
                BasicButtonDockTitle.this.mousePressed = (e.getModifiersEx() & 0x400) != 0;
                BasicButtonDockTitle.this.changeBorder();
            }
        });
        this.addColor(this.activeColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveColor);
        this.addColor(this.inactiveTextColor);
        this.addColor(this.selectedColor);
        this.addColor(this.selectedTextColor);
        this.addColor(this.knobActiveHighlightColor);
        this.addColor(this.knobActiveShadowColor);
        this.addColor(this.knobInactiveHighlightColor);
        this.addColor(this.knobInactiveShadowColor);
        this.addColor(this.knobSelectedHighlightColor);
        this.addColor(this.knobSelectedShadowColor);
        this.addConditionalFont("title.flap.active", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BasicButtonDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.flap.selected", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BasicButtonDockTitle.this.isSelected();
            }
        }, null);
        this.addConditionalFont("title.flap.inactive", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return !BasicButtonDockTitle.this.isActive();
            }
        }, null);
        this.allActionsSource.setSeparateSources(true);
        this.updateContent();
    }

    public void bind() {
        DockTitleVersion origin = this.getOrigin();
        if (origin != null) {
            this.connector.setProperties(origin.getController());
            this.behavior.setProperties(origin.getController());
        }
        this.behavior.setDockable(this.getDockable());
        super.bind();
    }

    public void unbind() {
        this.connector.setProperties((DockController)null);
        this.behavior.setProperties((DockController)null);
        this.behavior.setDockable(null);
        super.unbind();
    }

    private void updateContent() {
        this.updateIcon();
        this.updateText();
        this.updateActionSource(false);
        if (this.behavior.isShowActions() || this.behavior.isShowChildren()) {
            this.setShowMiniButtons(true);
        } else {
            this.setShowMiniButtons(false);
        }
        this.revalidate();
        this.repaint();
    }

    protected Insets getInnerInsets() {
        Insets base = super.getInnerInsets();
        if (this.behavior.isShowKnob()) {
            base = this.getOrientation().isHorizontal() ? new Insets(base.top, base.left + 10, base.bottom, base.right) : new Insets(base.top + 10, base.left, base.bottom, base.right);
        }
        return base;
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return this.allActionsSource;
    }

    private void updateActionSource(boolean force) {
        boolean showChildren = this.behavior.isShowChildren();
        boolean showActions = this.behavior.isShowActions();
        boolean filterActions = this.behavior.isFilterActions();
        if (force || this.showChildren != showChildren || this.showActions != showActions || this.filterActions != filterActions) {
            this.allActionsSource.removeAll();
            if (showChildren) {
                this.allActionsSource.add(this.getChildrenActionSourceFor(this.getDockable()));
            }
            if (showActions) {
                if (filterActions) {
                    this.allActionsSource.add(this.createFilter(this.getDefaultActionSourceFor(this.getDockable())));
                } else {
                    this.allActionsSource.add(this.getDefaultActionSourceFor(this.getDockable()));
                }
            }
            this.showChildren = showChildren;
            this.showActions = showActions;
        }
    }

    protected DockActionSource createFilter(DockActionSource actions) {
        final ButtonContentFilter connector = this.connector.getValue();
        return new FilteredDockActionSource(actions){

            protected boolean include(DockAction action) {
                return connector.isButtonAction(action);
            }
        };
    }

    protected DockActionSource getDefaultActionSourceFor(Dockable dockable) {
        return super.getActionSourceFor(dockable);
    }

    protected DockActionSource getChildrenActionSourceFor(Dockable dockable) {
        return new StationChildrenActionSource(dockable, null);
    }

    protected void updateIcon() {
        if (this.behavior.isShowIcon()) {
            super.updateIcon();
        } else {
            this.setIcon(null);
        }
    }

    protected void updateText() {
        if (this.behavior.isShowText()) {
            super.updateText();
        } else {
            this.setText("");
        }
    }

    protected void paintForeground(Graphics g, JComponent component) {
        this.paintIcon(g, component);
        if (this.behavior.isShowKnob()) {
            Insets insets = this.getInnerInsets();
            if (this.getOrientation().isHorizontal()) {
                int x = insets.left - 10 + 3;
                int y1 = insets.top + 3;
                int y2 = this.getHeight() - insets.bottom - 4;
                g.setColor(this.getColor(this.knobActiveHighlightColor, this.knobInactiveHighlightColor, this.knobSelectedHighlightColor));
                g.drawLine(x, y1, x, y2);
                g.drawLine(x, y1, x + 2, y1);
                g.setColor(this.getColor(this.knobActiveShadowColor, this.knobInactiveShadowColor, this.knobSelectedShadowColor));
                g.drawLine(x, y2, x + 2, y2);
                g.drawLine(x + 2, y1 + 1, x + 2, y2);
            } else {
                int y = insets.top - 10 + 3;
                int x1 = insets.left + 3;
                int x2 = this.getWidth() - insets.right - 4;
                g.setColor(this.getColor(this.knobActiveHighlightColor, this.knobInactiveHighlightColor, this.knobSelectedHighlightColor));
                g.drawLine(x1, y, x2, y);
                g.drawLine(x1, y, x1, y + 2);
                g.setColor(this.getColor(this.knobActiveShadowColor, this.knobInactiveShadowColor, this.knobSelectedShadowColor));
                g.drawLine(x1 + 1, y + 2, x2, y + 2);
                g.drawLine(x2, y, x2, y + 2);
            }
        }
    }

    public void setActive(boolean active) {
        if (active != this.isActive()) {
            super.setActive(active);
            this.selected = active;
            this.updateLayout();
        }
    }

    public void changed(DockTitleEvent event) {
        if (event instanceof ActivityDockTitleEvent) {
            ActivityDockTitleEvent activity = (ActivityDockTitleEvent)event;
            super.setActive(activity.isActive());
            this.selected = activity.isActive() || activity.isPreferred();
            this.updateLayout();
        } else {
            super.changed(event);
        }
    }

    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    protected boolean isMousePressed() {
        return this.mousePressed;
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void updateLayout() {
        this.changeBorder();
        this.updateColors();
        this.updateFonts();
    }

    protected void changeBorder() {
        if (this.selected && this.mousePressed) {
            this.setBorder("dock.border.title.button.selected.pressed", BorderFactory.createBevelBorder(0));
        } else if (this.selected) {
            this.setBorder("dock.border.title.button.selected", BorderFactory.createBevelBorder(1));
        } else if (this.mousePressed) {
            this.setBorder("dock.border.title.button.pressed", BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder("dock.border.title.button", BorderFactory.createBevelBorder(0));
        }
    }

    protected void updateColors() {
        if (this.isActive()) {
            this.setBackground(this.activeColor.color());
            this.setForeground(this.activeTextColor.color());
        } else if (this.selected) {
            this.setBackground(this.selectedColor.color());
            this.setForeground(this.selectedTextColor.color());
        } else {
            this.setBackground(this.inactiveColor.color());
            this.setForeground(this.inactiveTextColor.color());
        }
    }

    private Color getColor(TitleColor active, TitleColor inactive, TitleColor selected) {
        if (this.isActive()) {
            return active.color();
        }
        if (this.selected) {
            return selected.color();
        }
        return inactive.color();
    }

    public Color getActiveTextColor() {
        return this.activeTextColor.color();
    }

    public void setActiveTextColor(Color color) {
        this.activeTextColor.setValue(color);
    }

    public Color getActiveColor() {
        return this.activeColor.color();
    }

    public void setActiveColor(Color color) {
        this.activeColor.setValue(color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor.color();
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor.setValue(color);
    }

    public Color getSelectedColor() {
        return this.selectedColor.color();
    }

    public void setSelectedColor(Color color) {
        this.selectedColor.setValue(color);
    }

    public Color getInactiveTextColor() {
        return this.inactiveTextColor.color();
    }

    public void setInactiveTextColor(Color color) {
        this.inactiveTextColor.setValue(color);
    }

    public Color getInactiveColor() {
        return this.inactiveColor.color();
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor.setValue(color);
    }

    private class BasicTitleColor
    extends TitleColor {
        public BasicTitleColor(String id, Color backup) {
            super(id, TitleColor.KIND_FLAP_BUTTON_COLOR, BasicButtonDockTitle.this, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            BasicButtonDockTitle.this.updateColors();
        }
    }
}

