/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TabComponentLayoutManager
implements LayoutManager {
    private int freeSpaceToSideBorder;
    private int freeSpaceToParallelBorder;
    private int freeSpaceBetweenLabelAndActions;
    private int freeSpaceToOpenSide;
    private Insets labelInsets = new Insets(0, 0, 0, 0);
    private Insets actionInsets = new Insets(0, 0, 0, 0);
    private TabPlacement orientation;
    private OrientedLabel label;
    private ButtonPanel actions;
    private TabConfiguration configuration;

    public TabComponentLayoutManager(OrientedLabel label, ButtonPanel panel, TabConfiguration configuration) {
        this.label = label;
        this.actions = panel;
        this.setOrientation(TabPlacement.TOP_OF_DOCKABLE);
        this.setConfiguration(configuration);
    }

    public ButtonPanel getActions() {
        return this.actions;
    }

    public OrientedLabel getLabel() {
        return this.label;
    }

    public TabConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TabConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
        this.label.revalidate();
    }

    public void setFreeSpaceToOpenSide(int freeSpaceToOpenSide) {
        this.freeSpaceToOpenSide = freeSpaceToOpenSide;
    }

    public int getFreeSpaceToOpenSide() {
        return this.freeSpaceToOpenSide;
    }

    public void setFreeSpaceBetweenLabelAndActions(int freeSpaceBetweenLabelAndActions) {
        this.freeSpaceBetweenLabelAndActions = freeSpaceBetweenLabelAndActions;
    }

    public int getFreeSpaceBetweenLabelAndActions() {
        return this.freeSpaceBetweenLabelAndActions;
    }

    public void setFreeSpaceToParallelBorder(int freeSpaceToParallelBorder) {
        this.freeSpaceToParallelBorder = freeSpaceToParallelBorder;
    }

    public int getFreeSpaceToParallelBorder() {
        return this.freeSpaceToParallelBorder;
    }

    public void setFreeSpaceToSideBorder(int freeSpaceToSideBorder) {
        this.freeSpaceToSideBorder = freeSpaceToSideBorder;
    }

    public int getFreeSpaceToSideBorder() {
        return this.freeSpaceToSideBorder;
    }

    public void setLabelInsets(Insets labelInsets) {
        if (labelInsets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.labelInsets = new Insets(labelInsets.top, labelInsets.left, labelInsets.bottom, labelInsets.right);
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setActionInsets(Insets actionInsets) {
        if (this.labelInsets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.actionInsets = new Insets(actionInsets.top, actionInsets.left, actionInsets.bottom, actionInsets.right);
    }

    public Insets getActionInsets() {
        return this.actionInsets;
    }

    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.label.setHorizontal(orientation.isHorizontal());
            switch (orientation) {
                case BOTTOM_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.EAST_SIDED);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    break;
                }
                case TOP_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                }
            }
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (comp != this.label && comp != this.actions) {
            throw new IllegalArgumentException("must add either label or panel");
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension result;
        Dimension size = this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            result = new Dimension(size.width + 2 * this.freeSpaceToSideBorder + this.labelInsets.left + this.labelInsets.right, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                result.width += this.freeSpaceBetweenLabelAndActions;
                size = this.actions.getPreferredSize();
                result.width += size.width + this.actionInsets.left + this.actionInsets.right;
                result.height = Math.max(result.height, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.top + this.actionInsets.bottom);
            } else {
                result.width += this.actionInsets.right;
                result.height = Math.max(result.height, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.bottom);
            }
        } else {
            result = new Dimension(size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.left + this.labelInsets.right, size.height + 2 * this.freeSpaceToSideBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                result.height += this.freeSpaceBetweenLabelAndActions;
                size = this.actions.getPreferredSize();
                result.height += size.height + this.actionInsets.top + this.actionInsets.bottom;
                result.width = Math.max(result.width, size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.left + this.actionInsets.right);
            } else {
                result.height += this.actionInsets.bottom;
                result.width = Math.max(result.width, size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.right);
            }
        }
        return result;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension result;
        Dimension size = this.label.getMinimumSize();
        if (this.orientation.isHorizontal()) {
            result = new Dimension(size.width + 2 * this.freeSpaceToSideBorder + this.labelInsets.left + this.labelInsets.right, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                result.width += this.freeSpaceBetweenLabelAndActions;
                size = this.actions.getMinimumSize();
                result.width += size.width + this.actionInsets.left + this.actionInsets.right;
                result.height = Math.max(result.height, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.top + this.actionInsets.bottom);
            } else {
                result.width += this.actionInsets.right;
                result.height = Math.max(result.height, size.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.bottom);
            }
        } else {
            result = new Dimension(size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.left + this.labelInsets.right, size.height + 2 * this.freeSpaceToSideBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                result.height += this.freeSpaceBetweenLabelAndActions;
                size = this.actions.getMinimumSize();
                result.height += size.height + this.actionInsets.top + this.actionInsets.bottom;
                result.width = Math.max(result.width, size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.left + this.actionInsets.right);
            } else {
                result.height += this.actionInsets.bottom;
                result.width = Math.max(result.width, size.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.right);
            }
        }
        return result;
    }

    public void layoutContainer(Container parent) {
        Dimension actionsSize;
        int width = parent.getWidth();
        int height = parent.getHeight();
        boolean showActions = this.shouldShowActions(parent);
        if (showActions) {
            this.actions.setVisible(true);
            actionsSize = this.actions.getPreferredSize();
            actionsSize = new Dimension(actionsSize.width + this.actionInsets.left + this.actionInsets.right, actionsSize.height + this.actionInsets.top + this.actionInsets.bottom);
        } else {
            this.actions.setVisible(false);
            actionsSize = this.configuration.isHiddenActionUsingSpace() ? new Dimension(this.actionInsets.right, this.actionInsets.bottom) : new Dimension(0, 0);
        }
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToSideBorder + this.labelInsets.left, this.freeSpaceToOpenSide + this.labelInsets.top, this.labelSize(parent, width - 2 * this.freeSpaceToSideBorder - actionsSize.width - this.labelInsets.left - this.labelInsets.right, this.freeSpaceToSideBorder + this.labelInsets.left, showActions), height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.top - this.labelInsets.bottom);
                if (!showActions) break;
                int actionsHeight = Math.min(actionsSize.height, height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int delta = height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - actionsHeight - this.actionInsets.top - this.actionInsets.bottom;
                this.actions.setBounds(Math.max(0, width - this.freeSpaceToOpenSide - actionsSize.width + this.actionInsets.left), height - actionsHeight - this.freeSpaceToParallelBorder - delta / 2 + this.actionInsets.top, actionsSize.width - this.actionInsets.left - this.actionInsets.right, actionsHeight - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToSideBorder + this.labelInsets.left, this.freeSpaceToParallelBorder + this.labelInsets.top, this.labelSize(parent, width - 2 * this.freeSpaceToSideBorder - actionsSize.width - this.labelInsets.left - this.labelInsets.right, this.freeSpaceToSideBorder + this.labelInsets.left, showActions), height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.top - this.labelInsets.bottom);
                if (!showActions) break;
                int actionsHeight = Math.min(actionsSize.height, height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int delta = height - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - actionsHeight - this.actionInsets.top - this.actionInsets.bottom;
                this.actions.setBounds(Math.max(0, width - this.freeSpaceToOpenSide - actionsSize.width + this.actionInsets.left), this.freeSpaceToParallelBorder + delta / 2 + this.actionInsets.top, actionsSize.width - this.actionInsets.left - this.actionInsets.right, actionsHeight - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToParallelBorder + this.labelInsets.left, this.freeSpaceToSideBorder + this.labelInsets.top, width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.left - this.labelInsets.right, this.labelSize(parent, height - 2 * this.freeSpaceToSideBorder - actionsSize.height - this.labelInsets.top - this.labelInsets.bottom, this.freeSpaceToSideBorder + this.labelInsets.top, showActions));
                if (!showActions) break;
                int actionsWidth = Math.min(actionsSize.width, width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int delta = width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - actionsWidth - this.actionInsets.left - this.actionInsets.right;
                this.actions.setBounds(this.freeSpaceToParallelBorder + delta / 2 + this.actionInsets.left, Math.max(0, height - this.freeSpaceToOpenSide - actionsSize.height + this.actionInsets.top), actionsWidth - this.actionInsets.left - this.actionInsets.right, actionsSize.height - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToOpenSide + this.labelInsets.left, this.freeSpaceToSideBorder + this.labelInsets.top, width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.left - this.labelInsets.right, this.labelSize(parent, height - 2 * this.freeSpaceToSideBorder - actionsSize.height - this.labelInsets.top - this.labelInsets.bottom, this.freeSpaceToSideBorder + this.labelInsets.top, showActions));
                if (!showActions) break;
                int actionsWidth = Math.min(actionsSize.width, width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int delta = width - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - actionsWidth - this.actionInsets.left - this.actionInsets.right;
                this.actions.setBounds(width - actionsWidth - this.freeSpaceToParallelBorder - delta / 2 + this.actionInsets.left, Math.max(0, height - this.freeSpaceToOpenSide - actionsSize.height + this.actionInsets.top), actionsWidth - this.actionInsets.left - this.actionInsets.right, actionsSize.height - this.actionInsets.top - this.actionInsets.bottom);
            }
        }
        this.label.setIconHidden(!this.shouldShowIcon());
    }

    private int labelSize(Container parent, int suggested, int start, boolean showActions) {
        if (showActions) {
            return suggested;
        }
        if (this.configuration.isKeepLabelBig() && this.label.getIcon() != null) {
            if (this.orientation.isHorizontal()) {
                return Math.min(Math.max(suggested, this.label.getIconOffset() + this.label.getIcon().getIconWidth()), parent.getWidth() - start);
            }
            return Math.min(Math.max(suggested, this.label.getIconOffset() + this.label.getIcon().getIconHeight()), parent.getHeight() - start);
        }
        return suggested;
    }

    protected boolean shouldShowActions(Container parent) {
        if (!this.actions.hasActions()) {
            return false;
        }
        if (this.orientation.isHorizontal()) {
            int minSize = -1;
            int actionSize = this.actions.getPreferredSize().width;
            int labelDelta = this.freeSpaceToSideBorder + this.freeSpaceBetweenLabelAndActions + this.freeSpaceToOpenSide + this.labelInsets.left + this.labelInsets.right + this.actionInsets.left + this.actionInsets.right;
            switch (this.getConfiguration().getActionHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    minSize = actionSize;
                    break;
                }
                case TEXT_DISAPPEARING: {
                    minSize = labelDelta + this.label.getPreferredSize().width + actionSize;
                    break;
                }
                case ICON_DISAPPEARING: {
                    minSize = this.label.getIcon() == null ? -1 : labelDelta + this.label.getIconOffset() + this.label.getIcon().getIconWidth() + actionSize;
                }
            }
            return minSize <= parent.getWidth();
        }
        int minSize = -1;
        int actionSize = this.actions.getPreferredSize().height;
        int labelDelta = this.freeSpaceToSideBorder + this.freeSpaceBetweenLabelAndActions + this.freeSpaceToOpenSide + this.labelInsets.top + this.labelInsets.bottom + this.actionInsets.top + this.actionInsets.bottom;
        switch (this.getConfiguration().getActionHiding()) {
            case NEVER: {
                return true;
            }
            case NO_SPACE_LEFT: {
                minSize = actionSize;
                break;
            }
            case TEXT_DISAPPEARING: {
                minSize = labelDelta + this.label.getPreferredSize().height + actionSize;
                break;
            }
            case ICON_DISAPPEARING: {
                minSize = this.label.getIcon() == null ? -1 : labelDelta + this.label.getIconOffset() + this.label.getIcon().getIconHeight() + actionSize;
            }
        }
        return minSize <= parent.getHeight();
    }

    protected boolean shouldShowIcon() {
        if (this.label.getIcon() == null) {
            return true;
        }
        if (this.orientation.isHorizontal()) {
            switch (this.getConfiguration().getIconHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    return this.label.getWidth() >= this.label.getIconOffset() + this.label.getIcon().getIconWidth();
                }
                case TEXT_DISAPPEARING: {
                    return (double)this.label.getWidth() >= this.label.getPreferredSize().getWidth();
                }
            }
        } else {
            switch (this.getConfiguration().getIconHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    return this.label.getHeight() >= this.label.getIconOffset() + this.label.getIcon().getIconHeight();
                }
                case TEXT_DISAPPEARING: {
                    return (double)this.label.getHeight() >= this.label.getPreferredSize().getHeight();
                }
            }
        }
        return true;
    }

    public void removeLayoutComponent(Component comp) {
        throw new IllegalArgumentException("must not remove any components");
    }
}

