/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundDropDownButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation = new BubbleColorAnimation(){

        protected void pulse() {
            super.pulse();
            RoundDropDownButton.this.content.setLabelForeground(RoundDropDownButton.this.animation.getColor("text"));
        }
    };
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private RoundActionColor[] colors;
    private MiniButtonContent content;

    public RoundDropDownButton(BasicDropDownButtonHandler handler, Dockable dockable, DockAction action) {
        this.colors = new RoundActionColor[]{new RoundActionColor("action.dropdown", dockable, action, Color.WHITE), new RoundActionColor("action.dropdown.enabled", dockable, action, Color.LIGHT_GRAY), new RoundActionColor("action.dropdown.selected", dockable, action, Color.YELLOW), new RoundActionColor("action.dropdown.enabled.selected", dockable, action, Color.ORANGE), new RoundActionColor("action.dropdown.mouse.enabled", dockable, action, Color.RED), new RoundActionColor("action.dropdown.mouse.selected.enabled", dockable, action, new Color(128, 0, 0)), new RoundActionColor("action.dropdown.pressed.enabled", dockable, action, Color.BLUE), new RoundActionColor("action.dropdown.pressed.selected.enabled", dockable, action, Color.MAGENTA), new RoundActionColor("action.dropdown.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.selected.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.enabled.selected.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.mouse.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.pressed.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.selected", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.enabled.selected", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.mouse.selected.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.line.pressed.selected.enabled", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.dropdown.text", dockable, action, null), new RoundActionColor("action.dropdown.text.enabled", dockable, action, null), new RoundActionColor("action.dropdown.text.selected", dockable, action, null), new RoundActionColor("action.dropdown.text.enabled.selected", dockable, action, null), new RoundActionColor("action.dropdown.text.mouse.enabled", dockable, action, null), new RoundActionColor("action.dropdown.text.mouse.selected.enabled", dockable, action, null), new RoundActionColor("action.dropdown.text.pressed.enabled", dockable, action, null), new RoundActionColor("action.dropdown.text.pressed.selected.enabled", dockable, action, null)};
        this.animation.addTask(new Runnable(){

            public void run() {
                RoundDropDownButton.this.repaint();
            }
        });
        this.handler = handler;
        this.dropIcon = handler.getDropDownIcon();
        this.content = this.createButtonContent();
        this.setLayout(null);
        this.add(this.content);
        this.model = new BasicDropDownButtonModel(this, handler, handler){

            public void changed() {
                RoundDropDownButton.this.updateColors();
                RoundDropDownButton.this.revalidate();
                RoundDropDownButton.this.repaint();
            }

            protected boolean inDropDownArea(int x, int y) {
                return RoundDropDownButton.this.overDropIcon(x, y);
            }
        };
        this.content.setModel(this.model);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoundDropDownButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                RoundDropDownButton.this.repaint();
            }
        });
        this.updateColors();
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    public void setController(DockController controller) {
        for (RoundActionColor color : this.colors) {
            color.connect(controller);
        }
        this.animation.kick();
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    public void updateUI() {
        this.disabledDropIcon = null;
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension contentSize = this.content.getPreferredSize();
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension((int)(0.5 * (double)contentSize.height + (double)contentSize.width + 1.0 + 1.5 * (double)this.dropIcon.getIconWidth()), (int)(1.5 * (double)contentSize.height));
        }
        return new Dimension((int)(1.5 * (double)contentSize.width), (int)(0.5 * (double)contentSize.width + (double)contentSize.height + 1.0 + 1.5 * (double)this.dropIcon.getIconHeight()));
    }

    public void doLayout() {
        if (this.model.getOrientation().isHorizontal()) {
            this.content.setBounds(this.getHeight() / 3, this.getHeight() / 6, (int)((double)(this.getWidth() - 1) - 1.5 * (double)this.dropIcon.getIconWidth()), (int)((double)this.getHeight() / 1.5));
        } else {
            this.content.setBounds(this.getWidth() / 3, this.getWidth() / 6, (int)((double)this.getWidth() / 1.5), (int)((double)(this.getHeight() - 1) - 1.5 * (double)this.dropIcon.getIconHeight()));
        }
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        RoundRectangle2D.Double rect = this.model.getOrientation().isHorizontal() ? new RoundRectangle2D.Double(0.0, 0.0, w, h, h, h) : new RoundRectangle2D.Double(0.0, 0.0, w, h, w, w);
        return rect.contains(x, y);
    }

    protected void paintComponent(Graphics g) {
        BasicDropDownButtonModel model = this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            protected void foreground(Graphics g) {
                RoundDropDownButton.this.doPaintForeground(g);
            }

            protected void background(Graphics g) {
                RoundDropDownButton.this.doPaintBackground(g);
            }

            protected void border(Graphics g) {
            }

            protected void children(Graphics g) {
            }

            protected void overlay(Graphics g) {
            }

            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        paintable.paint(g2);
        g2.dispose();
    }

    private void doPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.model.getOrientation().isHorizontal()) {
            g2.setColor(this.animation.getColor("background"));
            g2.fillRoundRect(x, y, w, h, h, h);
        } else {
            g2.setColor(this.animation.getColor("background"));
            g2.fillRoundRect(x, y, w, h, w, w);
        }
    }

    private void doPaintForeground(Graphics g) {
        int dropIconHeight;
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = this.handler.getDisabledDropDownIcon();
            }
            drop = this.disabledDropIcon;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.paintChildren(g);
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        int dropIconWidth = drop == null ? 5 : drop.getIconWidth();
        int n = dropIconHeight = drop == null ? 5 : drop.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            g2.setColor(this.animation.getColor("mouse"));
            int mx = x + w - (int)(1.5 * (double)dropIconWidth) - 1;
            g2.drawLine(mx, y + 1, mx, y + h - 2);
            if (drop != null) {
                drop.paintIcon(this, g, (int)((double)(x + w) - 1.25 * (double)dropIconWidth), y + (h - dropIconHeight) / 2);
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = g2.getStroke();
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(this.animation.getColor("focus"));
                g2.drawRoundRect(x + 1, y + 1, w - 3, h - 3, h, h);
                g2.setStroke(stroke);
            }
        } else {
            g2.setColor(this.animation.getColor("mouse"));
            int my = y + h - (int)(1.5 * (double)dropIconHeight) - 1;
            g2.drawLine(x + 1, my, x + w - 2, my);
            if (drop != null) {
                drop.paintIcon(this, g, x + (w - dropIconWidth) / 2, (int)((double)(y + h) - 1.25 * (double)dropIconHeight));
            }
            if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
                Stroke stroke = g2.getStroke();
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(this.animation.getColor("focus"));
                g2.drawRoundRect(x + 1, y + 1, w - 3, h - 3, w, w);
                g2.setStroke(stroke);
            }
        }
    }

    public boolean overDropIcon(int x, int y) {
        int dropIconHeight;
        if (!this.contains(x, y)) {
            return false;
        }
        int rx = 0;
        int ry = 0;
        int rw = this.getWidth();
        int rh = this.getHeight();
        int dropIconWidth = this.dropIcon == null ? 0 : this.dropIcon.getIconWidth();
        int n = dropIconHeight = this.dropIcon == null ? 0 : this.dropIcon.getIconHeight();
        if (this.model.getOrientation().isHorizontal()) {
            int mx = rx + rw - (int)(1.5 * (double)dropIconWidth) - 1;
            return x >= mx;
        }
        int my = ry + rh - (int)(1.5 * (double)dropIconHeight) - 1;
        return y >= my;
    }

    public void updateColors() {
        String background;
        String postfix = "";
        boolean selected = this.model.isSelected();
        boolean enabled = this.model.isEnabled();
        boolean pressed = this.model.isMousePressed();
        boolean entered = this.model.isMouseInside();
        boolean mouseOverDrop = this.model.isMouseOverDropDown();
        if (selected) {
            postfix = ".selected";
        }
        if (enabled) {
            postfix = postfix + ".enabled";
        }
        String mouse = mouseOverDrop && enabled ? "dropdown.line" : "dropdown";
        String text = "action.dropdown.text";
        if (pressed && enabled) {
            background = "action.dropdown.pressed" + postfix;
            mouse = "action." + mouse + ".pressed" + postfix;
            text = text + ".pressed" + postfix;
        } else if (entered && enabled) {
            background = "action.dropdown.mouse" + postfix;
            mouse = "action." + mouse + ".mouse" + postfix;
            text = text + ".mouse" + postfix;
        } else {
            background = "action.dropdown" + postfix;
            mouse = "action." + mouse + postfix;
            text = text + postfix;
        }
        String focus = background + ".focus";
        for (RoundActionColor color : this.colors) {
            if (background.equals(color.getId())) {
                this.animation.putColor("background", (Color)color.value());
            }
            if (mouse.equals(color.getId())) {
                this.animation.putColor("mouse", (Color)color.value());
            }
            if (focus.equals(color.getId())) {
                this.animation.putColor("focus", (Color)color.value());
            }
            if (!text.equals(color.getId())) continue;
            this.animation.putColor("text", (Color)color.value());
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String id, Dockable dockable, DockAction action, Color backup) {
            super(id, dockable, action, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            RoundDropDownButton.this.updateColors();
        }
    }
}

