/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.plaf.PromptTextAreaUI;
import org.jdesktop.xswingx.plaf.PromptTextFieldUI;
import org.jdesktop.xswingx.plaf.PromptTextUI;

public class PromptSupport {
    public static final String PROMPT = "promptText";
    public static final String FOREGROUND = "promptForeground";
    public static final String BACKGROUND = "promptBackground";
    public static final String FOCUS_BEHAVIOR = "focusBehavior";
    public static final String FONT_STYLE = "promptFontStyle";
    public static final UIChangeHandler uiChangeHandler = new UIChangeHandler();

    private static void install(JTextComponent textComponent) {
        PromptSupport.replaceUIIfNeeded(textComponent);
        textComponent.addPropertyChangeListener("UI", uiChangeHandler);
    }

    private static void replaceUIIfNeeded(JTextComponent txt) {
        if (!(txt.getUI() instanceof PromptTextUI)) {
            txt.setUI(PromptSupport.wrapUI(txt.getUI()));
        }
    }

    public static void uninstall(JTextComponent textComponent) {
        textComponent.removePropertyChangeListener("UI", uiChangeHandler);
        textComponent.updateUI();
    }

    public static PromptTextUI wrapUI(JTextComponent textComponent) {
        return PromptSupport.wrapUI(textComponent.getUI());
    }

    public static PromptTextUI wrapUI(TextUI textUI) {
        if (textUI instanceof PromptTextUI) {
            return (PromptTextUI)textUI;
        }
        if (textUI instanceof BasicTextFieldUI) {
            return new PromptTextFieldUI(textUI);
        }
        if (textUI instanceof BasicTextAreaUI) {
            return new PromptTextAreaUI(textUI);
        }
        throw new IllegalArgumentException();
    }

    public static void init(String promptText, Color promptForeground, Color promptBackground, JTextComponent textComponent) {
        PromptSupport.setPrompt(promptText, textComponent);
        PromptSupport.setForeground(promptForeground, textComponent);
        PromptSupport.setBackground(promptBackground, textComponent);
    }

    public static FocusBehavior getFocusBehavior(JTextComponent textComponent) {
        FocusBehavior fb = (FocusBehavior)((Object)textComponent.getClientProperty(FOCUS_BEHAVIOR));
        if (fb == null) {
            fb = FocusBehavior.HIDE_PROMPT;
        }
        return fb;
    }

    public static void setFocusBehavior(FocusBehavior focusBehavior, JTextComponent textComponent) {
        textComponent.putClientProperty(FOCUS_BEHAVIOR, (Object)focusBehavior);
        if (textComponent.isFocusOwner()) {
            textComponent.repaint();
        }
    }

    public static String getPrompt(JTextComponent textComponent) {
        return (String)textComponent.getClientProperty(PROMPT);
    }

    public static void setPrompt(String promptText, JTextComponent textComponent) {
        PromptSupport.install(textComponent);
        if (textComponent.getToolTipText() == null || textComponent.getToolTipText().equals(PromptSupport.getPrompt(textComponent))) {
            textComponent.setToolTipText(promptText);
        }
        textComponent.putClientProperty(PROMPT, promptText);
    }

    public static Color getForeground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(FOREGROUND) == null) {
            return textComponent.getDisabledTextColor();
        }
        return (Color)textComponent.getClientProperty(FOREGROUND);
    }

    public static void setForeground(Color promptTextColor, JTextComponent textComponent) {
        textComponent.putClientProperty(FOREGROUND, promptTextColor);
        textComponent.repaint();
    }

    public static Color getBackground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(BACKGROUND) == null) {
            return textComponent.getBackground();
        }
        return (Color)textComponent.getClientProperty(BACKGROUND);
    }

    public static void setBackground(Color background, JTextComponent textComponent) {
        PromptSupport.install(textComponent);
        textComponent.putClientProperty(BACKGROUND, background);
        textComponent.repaint();
    }

    public static void setFontStyle(Integer fontStyle, JTextComponent textComponent) {
        textComponent.putClientProperty(FONT_STYLE, fontStyle);
        textComponent.revalidate();
        textComponent.repaint();
    }

    public static Integer getFontStyle(JTextComponent textComponent) {
        return (Integer)textComponent.getClientProperty(FONT_STYLE);
    }

    private static final class UIChangeHandler
    implements PropertyChangeListener {
        private UIChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent txt = (JTextComponent)evt.getSource();
            PromptSupport.replaceUIIfNeeded(txt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FocusBehavior {
        SHOW_PROMPT,
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

