/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.xml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.kabeja.xml.AbstractSAXSerializer;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXPrettyOutputter
extends AbstractSAXSerializer
implements SAXSerializer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String SUFFIX = "svg";
    public static final String SUFFIX_GZIP = "svgz";
    public static final String MIMETYPE = "text/svg";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_GZIP = "gzip";
    private OutputStreamWriter out;
    private String encoding;
    private String dtd;
    private int indent = 0;
    private boolean parent = false;
    private ArrayList textContentList = new ArrayList();
    protected HashMap rootxmlns = new HashMap();
    protected boolean gzip = false;

    public SAXPrettyOutputter(OutputStream output, String encoding) {
        this.encoding = encoding;
        this.setOutput(output);
    }

    public SAXPrettyOutputter(OutputStream out) {
        this(out, DEFAULT_ENCODING);
    }

    public SAXPrettyOutputter() {
        this.encoding = DEFAULT_ENCODING;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (length > 0) {
                if (this.parent) {
                    this.out.write(">");
                    this.parent = false;
                }
                char[] enc = SAXPrettyOutputter.encodeXML(new String(ch, 0, length)).toCharArray();
                this.out.write(enc, start, enc.length);
                this.textContentList.set(this.textContentList.size() - 1, new Boolean(true));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
            this.out.close();
            this.textContentList.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.parent) {
                this.out.write("/>");
            } else {
                Boolean b = (Boolean)this.textContentList.remove(this.textContentList.size() - 1);
                if (b.booleanValue()) {
                    this.out.write("</" + qName + ">");
                } else {
                    this.out.write(10);
                    this.indentOutput(this.indent);
                    this.out.write("</" + qName + ">");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        --this.indent;
        this.parent = false;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.indent = 0;
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>");
            if (this.dtd != null) {
                this.out.write("\n<!DOCTYPE " + this.dtd + ">");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ++this.indent;
        try {
            if (this.parent) {
                this.out.write(">");
            } else {
                this.parent = true;
            }
            this.out.write(10);
            this.indentOutput(this.indent);
            this.out.write("<" + qName);
            int attrCount = atts.getLength();
            for (int i = 0; i < attrCount; ++i) {
                this.indentOutput(1);
                String uri = atts.getURI(i);
                String qname = atts.getQName(i);
                String value = atts.getValue(i);
                if (value == null) {
                    value = "";
                }
                this.out.write(qname + "=\"" + SAXPrettyOutputter.encodeXML(atts.getValue(i)) + "\"");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textContentList.add(false);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void indentOutput(int indentSize) {
        try {
            for (int i = 0; i < indentSize; ++i) {
                this.out.write(32);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String encodeXML(String text) {
        int length = text.length();
        StringBuffer work = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                work.append("&amp;");
                continue;
            }
            if (c == '<') {
                work.append("&lt;");
                continue;
            }
            if (c == '>') {
                work.append("&gt;");
                continue;
            }
            if (Character.isIdentifierIgnorable(c)) continue;
            work.append(c);
        }
        return work.toString();
    }

    public void setDTD(String dtd) {
        this.dtd = dtd;
    }

    protected void queryXMLNS(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String qname = atts.getQName(i);
            if (!qname.startsWith("xmlns:")) continue;
            String prefix = atts.getLocalName(i);
            String uri = atts.getValue(i);
            this.rootxmlns.put(uri, prefix);
        }
    }

    public String getMimeType() {
        return MIMETYPE;
    }

    public String getSuffix() {
        if (this.gzip) {
            return SUFFIX_GZIP;
        }
        return SUFFIX;
    }

    public void setOutput(OutputStream out) {
        BufferedOutputStream bout = null;
        try {
            bout = this.gzip ? new BufferedOutputStream(new GZIPOutputStream(out)) : new BufferedOutputStream(out);
            this.out = new OutputStreamWriter((OutputStream)bout, this.encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProperties(Map properties) {
        this.properties = properties;
        if (properties.containsKey(PROPERTY_ENCODING)) {
            this.encoding = (String)properties.get(PROPERTY_ENCODING);
        }
        if (properties.containsKey(PROPERTY_GZIP)) {
            this.gzip = Boolean.getBoolean((String)properties.get(PROPERTY_GZIP));
        }
    }
}

