/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.Application;
import org.kabeja.ui.ApplicationMenuBar;
import org.kabeja.ui.Component;
import org.kabeja.ui.ProcessingUIComponent;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.Startable;
import org.kabeja.ui.impl.OpenProcessingAction;

public class ServiceContainer
implements ServiceManager,
Application {
    protected List components = new ArrayList();
    protected ProcessingManager manager;

    public ServiceContainer() {
        this.addComponent(this);
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public Component[] getServiceComponents(String service) {
        List l = this.getServiceComponentsByServiceField(service);
        return l.toArray(new Component[l.size()]);
    }

    protected List getServiceComponentsByServiceField(String service) {
        ArrayList list = new ArrayList();
        Iterator i = this.components.iterator();
        try {
            Class<?> serviceClass = this.getClass().getClassLoader().loadClass(service);
            while (i.hasNext()) {
                Object obj = i.next();
                if (!serviceClass.isInstance(obj)) continue;
                list.add(obj);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void setupComponents() {
        ArrayList list = new ArrayList();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Serviceable)) continue;
            ((Serviceable)obj).setServiceManager(this);
        }
        ApplicationMenuBar mbar = (ApplicationMenuBar)((Object)this.getServiceComponents(ApplicationMenuBar.SERVICE)[0]);
        mbar.setAction("menu.file", new OpenProcessingAction(this));
    }

    public void start() {
        this.setupComponents();
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Startable)) continue;
            ((Startable)obj).start();
        }
    }

    public void stop() {
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Startable)) continue;
            ((Startable)obj).stop();
        }
        System.exit(0);
    }

    public void setProcessingManager(ProcessingManager manager) {
        this.manager = manager;
        Iterator i = this.components.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ProcessingUIComponent)) continue;
            ((ProcessingUIComponent)obj).setProcessingManager(manager);
        }
    }
}

