/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.kabeja.ui.impl.ProcessingRunViewComponent;

public class DXFFileTransferHandler
extends TransferHandler {
    private ProcessingRunViewComponent c;

    public DXFFileTransferHandler(ProcessingRunViewComponent c) {
        this.c = c;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i;
        for (i = 0; i < flavors.length; ++i) {
            if (!flavors[i].isFlavorJavaFileListType()) continue;
            return true;
        }
        for (i = 0; i < flavors.length; ++i) {
            if (!flavors[i].isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getFileList(Transferable t) {
        ArrayList<File> files = new ArrayList<File>();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() <= 0) return files;
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    files.add(file);
                }
                return files;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                return files;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return files;
            }
        }
        if (!t.isDataFlavorSupported(DataFlavor.stringFlavor)) return files;
        try {
            String text = (String)t.getTransferData(DataFlavor.stringFlavor);
            String[] list = text.split("\n");
            if (list.length <= 0) return files;
            for (int i = 0; i < list.length; ++i) {
                File f = new File(list[i]);
                if (f.exists()) {
                    files.add(f);
                    continue;
                }
                if (!list[i].startsWith("file:")) continue;
                try {
                    f = new File(new URI(list[i].trim()));
                    files.add(f);
                    continue;
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
            return files;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return files;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    public boolean importData(JComponent c, Transferable t) {
        List files = this.getFileList(t);
        if (files.size() > 0) {
            File f = (File)files.get(0);
            if (f.getAbsolutePath().toLowerCase().endsWith(".dxf")) {
                this.c.processInput(f);
            }
            return true;
        }
        return false;
    }
}

