/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.kabeja.parser.Parser;
import org.kabeja.parser.SAXParserBuilder;
import org.kabeja.processing.PostProcessor;
import org.kabeja.processing.PostProcessorConfig;
import org.kabeja.processing.ProcessPipeline;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.tools.SAXFilterConfig;
import org.kabeja.xml.AggregatorGenerator;
import org.kabeja.xml.SAXFilter;
import org.kabeja.xml.SAXGenerator;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXProcessingManagerBuilder
implements ContentHandler {
    public static String XMLNS_KABEJA_PROCESSING = "http://kabeja.org/processing/1.0";
    public static final String ELEMENT_CONFIGURATION = "configuration";
    public static final String ELEMENT_PARSER = "parser";
    public static final String ELEMENT_PARSERS = "parsers";
    public static final String ELEMENT_SAXSERIALIZER = "serializer";
    public static final String ELEMENT_SAXSERIALIZERS = "serializers";
    public static final String ELEMENT_SAXFILTER = "filter";
    public static final String ELEMENT_FILTER = "filter";
    public static final String ELEMENT_SAXFILTERS = "filters";
    public static final String ELEMENT_PIPELINE = "pipeline";
    public static final String ELEMENT_PIPELINES = "pipelines";
    public static final String ELEMENT_SERIALIZE = "serialize";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_POSTPROCESSOR = "postprocessor";
    public static final String ELEMENT_POSTPROCESS = "postprocess";
    public static final String ELEMENT_AGGREGATE = "aggregate";
    public static final String ELEMENT_SAXGENERATOR = "generator";
    public static final String ELEMENT_GENERATE = "generate";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    private ProcessingManager manager;
    private SAXFilter saxfilter;
    private SAXSerializer saxserializer;
    private PostProcessor postprocessor;
    private SAXGenerator saxgenerator;
    private AggregatorGenerator aggregator;
    private Map properties;
    private StringBuffer buf = new StringBuffer();
    private String name;
    private ProcessPipeline pipeline;
    private boolean config = false;
    private boolean aggregate = false;
    protected SAXParserBuilder parserBuilder;

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (namespaceURI.equals(XMLNS_KABEJA_PROCESSING)) {
            if ("filter".equals(localName) && this.config) {
                this.saxfilter.setProperties(this.properties);
                this.manager.addSAXFilter(this.saxfilter, this.name);
            } else if (ELEMENT_SAXSERIALIZER.equals(localName)) {
                this.saxserializer.setProperties(this.properties);
                this.manager.addSAXSerializer(this.saxserializer, this.name);
            } else if (ELEMENT_PIPELINE.equals(localName)) {
                this.manager.addProcessPipeline(this.pipeline);
            } else if (ELEMENT_SERIALIZE.equals(localName)) {
                this.pipeline.setSAXSerializer(this.manager.getSAXSerializer(this.name));
                this.pipeline.setSAXSerializerProperties(this.properties);
            } else if ("filter".equals(localName)) {
                SAXFilterConfig config = new SAXFilterConfig(this.properties);
                config.setFilterName(this.name);
                this.pipeline.addSAXFilterConfig(config);
            } else if (ELEMENT_POSTPROCESS.equals(localName)) {
                PostProcessorConfig config = new PostProcessorConfig(this.properties);
                config.setPostProcessorName(this.name);
                this.pipeline.addPostProcessorConfig(config);
            } else if (ELEMENT_POSTPROCESSOR.equals(localName)) {
                this.postprocessor.setProperties(this.properties);
                this.manager.addPostProcessor(this.postprocessor, this.name);
            } else if (ELEMENT_CONFIGURATION.equals(localName)) {
                this.config = false;
            } else if (ELEMENT_GENERATE.equals(localName)) {
                if (this.aggregate) {
                    this.aggregator.addSAXGenerator(this.manager.getSAXGenerator(this.name));
                } else {
                    this.pipeline.setSAXGeneratorProperties(this.properties);
                    this.pipeline.setSAXGenerator(this.manager.getSAXGenerator(this.name));
                }
            } else if (ELEMENT_SAXGENERATOR.equals(localName)) {
                this.saxgenerator.setProperties(this.properties);
                this.manager.addSAXGenerator(this.saxgenerator, this.name);
            }
        } else if (namespaceURI.equals(SAXParserBuilder.XMLNS_KABEJA_PARSER)) {
            this.parserBuilder.endElement(namespaceURI, localName, qName);
            if (localName.equals(ELEMENT_PARSER)) {
                this.parserBuilder.endDocument();
                Parser p = this.parserBuilder.getParser();
                this.manager.addParser(p);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.manager = new ProcessingManager();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals(XMLNS_KABEJA_PROCESSING)) {
            if ("filter".equals(localName) && this.config) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
                this.saxfilter = (SAXFilter)this.createInstance(atts.getValue(ATTRIBUTE_CLASS));
            } else if (ELEMENT_SAXSERIALIZER.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
                this.saxserializer = (SAXSerializer)this.createInstance(atts.getValue(ATTRIBUTE_CLASS));
            } else if (ELEMENT_POSTPROCESSOR.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
                String clazz = atts.getValue(ATTRIBUTE_CLASS);
                this.postprocessor = (PostProcessor)this.createInstance(clazz);
            } else if (ELEMENT_PIPELINE.equals(localName)) {
                this.aggregate = false;
                this.pipeline = new ProcessPipeline();
                this.pipeline.setName(atts.getValue(ATTRIBUTE_NAME));
                String des = atts.getValue(ATTRIBUTE_DESCRIPTION);
                if (des != null) {
                    this.pipeline.setDescription(des);
                }
            } else if (ELEMENT_SERIALIZE.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
            } else if ("filter".equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_PROPERTY.equals(localName)) {
                this.properties.put(atts.getValue(ATTRIBUTE_NAME), atts.getValue(ATTRIBUTE_VALUE));
            } else if (ELEMENT_POSTPROCESS.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_CONFIGURATION.equals(localName)) {
                this.config = true;
            } else if (ELEMENT_SAXGENERATOR.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
                String clazz = atts.getValue(ATTRIBUTE_CLASS);
                this.saxgenerator = (SAXGenerator)this.createInstance(clazz);
            } else if (ELEMENT_GENERATE.equals(localName)) {
                this.properties = new HashMap();
                this.name = atts.getValue(ATTRIBUTE_NAME);
            } else if (ELEMENT_AGGREGATE.equals(localName)) {
                this.aggregate = true;
                this.aggregator = new AggregatorGenerator();
                this.pipeline.setSAXGenerator(this.aggregator);
            }
        } else if (namespaceURI.equals(SAXParserBuilder.XMLNS_KABEJA_PARSER)) {
            if (localName.equals(ELEMENT_PARSER)) {
                this.parserBuilder = new SAXParserBuilder();
                this.parserBuilder.startDocument();
            }
            this.parserBuilder.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public ProcessingManager getManager() {
        return this.manager;
    }

    protected Object createInstance(String clazz) {
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass(clazz);
            Object obj = cl.newInstance();
            return obj;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ProcessingManager buildFromStream(InputStream in) {
        SAXProcessingManagerBuilder builder = new SAXProcessingManagerBuilder();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            catch (Exception e) {
                System.out.println("No XInclude support (use JAXP 1.4 or later for XInclude)");
            }
            try {
                XMLReader saxparser = factory.newSAXParser().getXMLReader();
                saxparser.setContentHandler(builder);
                saxparser.parse(new InputSource(in));
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return builder.getManager();
    }
}

