/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class FontManager {
    private static FontManager instance = new FontManager();
    private String fontDescription = "conf/font.properties";
    private Hashtable fontProperties = new Hashtable();

    private FontManager() {
        this.loadFontDescription();
    }

    public void setFontDescription(String file) {
        this.fontDescription = file;
        this.loadFontDescription();
    }

    private void loadFontDescription() {
        this.fontProperties.clear();
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.fontDescription);
            if (stream == null) {
                try {
                    stream = new FileInputStream(this.fontDescription);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (stream != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while ((line = in.readLine()) != null) {
                    int index = line.indexOf("=");
                    if (index < 0) continue;
                    String font = line.substring(0, index).trim().toLowerCase();
                    String svgFont = line.substring(index + 1).trim();
                    this.fontProperties.put(font, svgFont);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FontManager getInstance() {
        return instance;
    }

    public boolean hasFontDescription(String font) {
        return this.fontProperties.containsKey(font = this.getFontKey(font));
    }

    public String getFontDescription(String font) {
        return (String)this.fontProperties.get(this.getFontKey(font));
    }

    private String getFontKey(String font) {
        if ((font = font.toLowerCase()).endsWith(".shx")) {
            font = font.substring(0, font.indexOf(".shx"));
        }
        return font;
    }
}

