/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.tools;

import java.io.BufferedReader;
import java.io.IOException;

public class CodePageParser {
    public static final String CODEPAGE_CODE = "$DWGCODEPAGE";
    public static final String GROUPCODE = "3";
    private static final String[] prefix = new String[]{"ansi_", "dos"};
    private static final String javaPrefix = "Cp";

    public String parseEncoding(BufferedReader reader) {
        String encoding = "";
        try {
            String line = null;
            boolean next = true;
            boolean codepage = false;
            boolean key = true;
            String currentKey = null;
            while ((line = reader.readLine()) != null && next) {
                line = line.trim();
                if (key) {
                    currentKey = line;
                    key = false;
                    continue;
                }
                key = true;
                if ("ENDSEC".equals(line)) {
                    return encoding;
                }
                if (CODEPAGE_CODE.equals(line)) {
                    codepage = true;
                    continue;
                }
                if (codepage && currentKey.equals(GROUPCODE)) {
                    return this.translateCodePage(line);
                }
                if (!"CLASSES".equals(line) && !"BLOCKS".equals(line) && !"ENTITIES".equals(line)) continue;
                return encoding;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public String translateCodePage(String cp) {
        String c = cp.toLowerCase();
        for (int i = 0; i < prefix.length; ++i) {
            if (!c.startsWith(prefix[i])) continue;
            return javaPrefix + cp.substring(prefix[i].length());
        }
        return cp;
    }
}

