/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLWPolyline;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.helper.PolylineQueue;

public class PolylineConverter
extends AbstractPostProcessor {
    public static final String PROPERTY_POINT_DISTANCE = "point.distance";
    private List queues;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        Iterator i = doc.getDXFLayerIterator();
        while (i.hasNext()) {
            DXFLayer layer = (DXFLayer)i.next();
            this.processLayer(layer);
        }
    }

    public void setProperties(Map properties) {
        if (properties.containsKey(PROPERTY_POINT_DISTANCE)) {
            this.radius = Double.parseDouble((String)properties.get(PROPERTY_POINT_DISTANCE));
        }
    }

    protected void processLayer(DXFLayer layer) {
        DXFPolyline pl;
        Point end;
        Point start;
        Iterator i;
        List l;
        this.queues = new ArrayList();
        if (layer.hasDXFEntities("LINE")) {
            l = layer.getDXFEntities("LINE");
            i = l.iterator();
            while (i.hasNext()) {
                DXFLine line = (DXFLine)i.next();
                start = line.getStartPoint();
                end = line.getEndPoint();
                this.checkDXFEntity(line, start, end);
            }
        }
        if (layer.hasDXFEntities("POLYLINE")) {
            l = layer.getDXFEntities("POLYLINE");
            i = l.iterator();
            while (i.hasNext()) {
                pl = (DXFPolyline)i.next();
                if (pl.isClosed() || pl.is3DPolygonMesh() || pl.isClosedMeshMDirection() || pl.isClosedMeshNDirection() || pl.isCubicSurefaceMesh()) continue;
                start = pl.getVertex(0).getPoint();
                end = pl.getVertex(pl.getVertexCount() - 1).getPoint();
                this.checkDXFEntity(pl, start, end);
            }
        }
        if (layer.hasDXFEntities("LWPOLYLINE")) {
            l = layer.getDXFEntities("LWPOLYLINE");
            i = l.iterator();
            while (i.hasNext()) {
                pl = (DXFLWPolyline)i.next();
                if (pl.isClosed() || pl.is3DPolygonMesh() || pl.isClosedMeshMDirection() || pl.isClosedMeshNDirection() || pl.isCubicSurefaceMesh()) continue;
                start = pl.getVertex(0).getPoint();
                end = pl.getVertex(pl.getVertexCount() - 1).getPoint();
                this.checkDXFEntity(pl, start, end);
            }
        }
        if (layer.hasDXFEntities("ARC")) {
            l = layer.getDXFEntities("ARC");
            i = l.iterator();
            while (i.hasNext()) {
                DXFArc arc = (DXFArc)i.next();
                start = arc.getStartPoint();
                end = arc.getEndPoint();
                this.checkDXFEntity(arc, start, end);
            }
        }
        this.connectPolylineQueues();
        this.cleanUp(layer);
    }

    protected void checkDXFEntity(DXFEntity e, Point start, Point end) {
        PolylineQueue queue;
        Iterator i = this.queues.iterator();
        while (i.hasNext()) {
            queue = (PolylineQueue)i.next();
            if (!queue.connectDXFEntity(e, start, end)) continue;
            return;
        }
        queue = new PolylineQueue(e, start, end, this.radius);
        this.queues.add(queue);
    }

    protected void cleanUp(DXFLayer layer) {
        Iterator i = this.queues.iterator();
        while (i.hasNext()) {
            PolylineQueue queue = (PolylineQueue)i.next();
            if (queue.size() > 1) {
                queue.createDXFPolyline(layer);
                continue;
            }
            i.remove();
        }
    }

    protected void connectPolylineQueues() {
        for (int i = 0; i < this.queues.size(); ++i) {
            PolylineQueue queue = (PolylineQueue)this.queues.get(i);
            boolean connected = false;
            for (int x = i + 1; x < this.queues.size() && !connected; ++x) {
                if (!((PolylineQueue)this.queues.get(x)).connect(queue)) continue;
                this.queues.remove(i);
                --i;
                connected = true;
            }
        }
    }
}

