/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXF3DFace;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFText;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class BoundsDebugger
extends AbstractPostProcessor {
    public static final String LAYER_NAME = "kabeja_bounds_debug";

    public void process(DXFDocument doc, Map context) throws ProcessorException {
        Iterator i = doc.getDXFBlockIterator();
        while (i.hasNext()) {
            DXFBlock b = (DXFBlock)i.next();
            Iterator ie = b.getDXFEntitiesIterator();
            while (ie.hasNext()) {
                DXFEntity entity = (DXFEntity)ie.next();
                entity.setColor(9);
            }
        }
        DXFEntity left = null;
        DXFEntity top = null;
        DXFEntity right = null;
        DXFEntity bottom = null;
        Bounds b = doc.getBounds();
        double x = b.getMinimumX() + b.getWidth() / 2.0;
        double y = b.getMinimumY() + b.getHeight() / 2.0;
        Bounds lBounds = new Bounds(x, x, y, y);
        Bounds rBounds = new Bounds(x, x, y, y);
        Bounds tBounds = new Bounds(x, x, y, y);
        Bounds bBounds = new Bounds(x, x, y, y);
        i = doc.getDXFLayerIterator();
        while (i.hasNext()) {
            DXFLayer l = (DXFLayer)i.next();
            l.setColor(8);
            Iterator ti = l.getDXFEntityTypeIterator();
            while (ti.hasNext()) {
                String type = (String)ti.next();
                Iterator ei = l.getDXFEntities(type).iterator();
                while (ei.hasNext()) {
                    DXFEntity entity = (DXFEntity)ei.next();
                    entity.setColor(8);
                    Bounds currentBounds = entity.getBounds();
                    if (!currentBounds.isValid()) continue;
                    if (currentBounds.getMinimumX() <= lBounds.getMinimumX()) {
                        lBounds = currentBounds;
                        left = entity;
                    }
                    if (currentBounds.getMinimumY() <= bBounds.getMinimumY()) {
                        bBounds = currentBounds;
                        bottom = entity;
                    }
                    if (currentBounds.getMaximumX() >= rBounds.getMaximumX()) {
                        rBounds = currentBounds;
                        right = entity;
                    }
                    if (!(currentBounds.getMaximumY() >= tBounds.getMaximumY())) continue;
                    tBounds = currentBounds;
                    top = entity;
                }
            }
        }
        left.setColor(0);
        this.addBounds(lBounds, doc, 0, left.getType() + "=" + left.getID());
        right.setColor(2);
        this.addBounds(rBounds, doc, 2, right.getType() + "=" + right.getID());
        bottom.setColor(4);
        this.addBounds(bBounds, doc, 4, bottom.getType() + "=" + bottom.getID());
        top.setColor(5);
        this.addBounds(tBounds, doc, 5, top.getType() + "=" + top.getID());
        top.setColor(5);
        this.addBounds(b, doc, 6, "ALL");
    }

    protected void addBounds(Bounds bounds, DXFDocument doc, int color, String type) {
        DXF3DFace face = new DXF3DFace();
        face.getPoint1().setX(bounds.getMinimumX());
        face.getPoint1().setY(bounds.getMinimumY());
        face.getPoint2().setX(bounds.getMinimumX());
        face.getPoint2().setY(bounds.getMaximumY());
        face.getPoint3().setX(bounds.getMaximumX());
        face.getPoint3().setY(bounds.getMaximumY());
        face.getPoint4().setX(bounds.getMaximumX());
        face.getPoint4().setY(bounds.getMinimumY());
        face.setColor(color);
        face.setLayerName(LAYER_NAME);
        doc.addDXFEntity(face);
        DXFText t = new DXFText();
        t.setDXFDocument(doc);
        t.setText("DEBUG-" + type);
        t.getInsertPoint().setX(bounds.getMinimumX());
        t.getInsertPoint().setY(bounds.getMaximumY());
        t.setColor(color);
        t.setLayerName(LAYER_NAME);
        doc.addDXFEntity(t);
    }

    public void setProperties(Map properties) {
    }
}

