/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.table;

import org.kabeja.dxf.DXFViewport;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.table.AbstractTableHandler;

public class DXFVPortTableHandler
extends AbstractTableHandler {
    public static final int GROUPCODE_VPORT_NAME = 2;
    public static final int GROUPCODE_VPORT_LOWER_LEFT_X = 10;
    public static final int GROUPCODE_VPORT_LOWER_LEFT_Y = 20;
    public static final int GROUPCODE_VPORT_UPPER_RIGHT_X = 11;
    public static final int GROUPCODE_VPORT_UPPER_RIGHT_Y = 21;
    public static final int GROUPCODE_VPORT_CENTER_POINT_X = 12;
    public static final int GROUPCODE_VPORT_CENTER_POINT_Y = 22;
    public static final int GROUPCODE_VPORT_SNAP_BASE_POINT_X = 13;
    public static final int GROUPCODE_VPORT_SNAP_BASE_POINT_Y = 23;
    public static final int GROUPCODE_HEIGHT = 40;
    public static final int GROUPCODE_ASPECT_RATIO = 41;
    public static final int GROUPCODE_TWIST_ANGLE = 51;
    private DXFViewport viewport;

    public void endParsing() {
        this.doc.addDXFViewport(this.viewport);
    }

    public String getTableKey() {
        return "VPORT";
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 2: {
                this.viewport.setViewportID(value.getValue());
                if (!"*active".equals(value.getValue().toLowerCase())) break;
                this.viewport.setActive(true);
                break;
            }
            case 12: {
                this.viewport.getCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.viewport.getCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 10: {
                this.viewport.getLowerLeftCorner().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.viewport.getLowerLeftCorner().setY(value.getDoubleValue());
                break;
            }
            case 40: {
                this.viewport.setHeight(value.getDoubleValue());
                break;
            }
            case 41: {
                this.viewport.setAspectRatio(value.getDoubleValue());
                break;
            }
            case 51: {
                this.viewport.setTwistAngle(value.getDoubleValue());
            }
        }
    }

    public void startParsing() {
        this.viewport = new DXFViewport();
    }
}

