/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.table;

import org.kabeja.dxf.DXFUcs;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.table.AbstractTableHandler;

public class DXFUcsTableHandler
extends AbstractTableHandler {
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_CENTER_X = 10;
    public static final int GROUPCODE_CENTER_Y = 20;
    public static final int GROUPCODE_CENTER_Z = 30;
    public static final int GROUPCODE_UCS_X_AXIS_X = 11;
    public static final int GROUPCODE_UCS_X_AXIS_Y = 21;
    public static final int GROUPCODE_UCS_X_AXIS_Z = 31;
    public static final int GROUPCODE_UCS_Y_AXIS_X = 12;
    public static final int GROUPCODE_UCS_Y_AXIS_Y = 22;
    public static final int GROUPCODE_UCS_Y_AXIS_Z = 32;
    private DXFUcs ucs;

    public void endParsing() {
        this.doc.setDXFUcs(this.ucs);
    }

    public String getTableKey() {
        return "UCS";
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.ucs.getCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.ucs.getCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.ucs.getCenterPoint().setZ(value.getDoubleValue());
                break;
            }
            case 2: {
                this.ucs.setName(value.getValue());
                break;
            }
            case 11: {
                this.ucs.getUcsXAxis().setX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.ucs.getUcsXAxis().setY(value.getDoubleValue());
                break;
            }
            case 31: {
                this.ucs.getUcsXAxis().setZ(value.getDoubleValue());
                break;
            }
            case 12: {
                this.ucs.getUcsYAxis().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.ucs.getUcsYAxis().setY(value.getDoubleValue());
                break;
            }
            case 32: {
                this.ucs.getUcsYAxis().setZ(value.getDoubleValue());
            }
        }
    }

    public void startParsing() {
        this.ucs = new DXFUcs();
    }
}

