/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.table;

import org.kabeja.dxf.DXFStyle;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.table.AbstractTableHandler;

public class DXFStyleTableHandler
extends AbstractTableHandler {
    public static String TABLE_KEY = "STYLE";
    public static final int GROUPCODE_NAME = 2;
    public static final int GROUPCODE_TEXT_HEIGHT = 40;
    public static final int GROUPCODE_WIDTH_FACTOR = 41;
    public static final int GROUPCODE_OBLIQUE_ANGLE = 50;
    public static final int GROUPCODE_TEXT_GENERATION_FLAG = 71;
    public static final int GROUPCODE_FLAGS = 70;
    public static final int GROUPCODE_LAST_HEIGHT = 42;
    public static final int GROUPCODE_FONT_FILE = 3;
    public static final int GROUPCODE_BIG_FONT_FILE = 4;
    private DXFStyle style;

    public void endParsing() {
        this.doc.addDXStyle(this.style);
    }

    public String getTableKey() {
        return TABLE_KEY;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 2: {
                this.style.setName(value.getValue());
                break;
            }
            case 40: {
                this.style.setTextHeight(value.getDoubleValue());
                break;
            }
            case 41: {
                this.style.setWidthFactor(value.getDoubleValue());
                break;
            }
            case 50: {
                this.style.setObliqueAngle(value.getDoubleValue());
                break;
            }
            case 71: {
                this.style.setTextGenerationFlag(value.getIntegerValue());
                break;
            }
            case 42: {
                this.style.setLastHeight(value.getDoubleValue());
                break;
            }
            case 3: {
                this.style.setFontFile(value.getValue());
                break;
            }
            case 4: {
                this.style.setBigFontFile(value.getValue());
                break;
            }
            case 70: {
                this.style.setFlags(value.getIntegerValue());
            }
        }
    }

    public void startParsing() {
        this.style = new DXFStyle();
    }
}

