/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.table;

import org.kabeja.dxf.DXFLineType;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.table.AbstractTableHandler;

public class DXFLineTypeTableHandler
extends AbstractTableHandler {
    public static final String TABLE_KEY = "LTYPE";
    public static final int GROUPCODE_LTYPE_NAME = 2;
    public static final int GROUPCODE_LTYPE_DESCRIPTION = 3;
    public static final int GROUPCODE_LTYPE_ALIGNMENT = 72;
    public static final int GROUPCODE_LTYPE_SEGMENT = 49;
    public static final int GROUPCODE_LTYPE_LENGTH = 40;
    public static final int GROUPCODE_LTYPE_SEGMENT_COUNT = 73;
    public static final int GROUPCODE_LTYPE_SCALE = 46;
    private DXFLineType ltype;
    private int segmentCount = 0;
    private double[] pattern;

    public void endParsing() {
        this.ltype.setPattern(this.pattern);
        this.doc.addDXFLineType(this.ltype);
    }

    public String getTableKey() {
        return TABLE_KEY;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 2: {
                this.ltype.setName(value.getValue());
                break;
            }
            case 3: {
                this.ltype.setDescritpion(value.getValue());
                break;
            }
            case 73: {
                int count = value.getIntegerValue();
                this.pattern = new double[count];
                this.segmentCount = 0;
                break;
            }
            case 49: {
                this.pattern[this.segmentCount] = value.getDoubleValue();
                ++this.segmentCount;
                break;
            }
            case 40: {
                this.ltype.setPatternLength(value.getDoubleValue());
                break;
            }
            case 72: {
                this.ltype.setAlignment(value.getIntegerValue());
                break;
            }
            case 46: {
                this.ltype.setScale(value.getDoubleValue());
                break;
            }
        }
    }

    public void startParsing() {
        this.ltype = new DXFLineType();
        this.segmentCount = 0;
        this.pattern = null;
    }
}

