/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFText;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFTextHandler
extends AbstractEntityHandler {
    public static final int TEXT_VALUE = 1;
    public static final int TEXT_HEIGHT = 40;
    public static final int TEXT_SCALEX = 41;
    public static final int TEXT_GENERATION_FLAG = 71;
    public static final int TEXT_ALIGN = 72;
    public static final int TEXT_VALIGN = 73;
    public static final int TEXT_ALIGN_X = 11;
    public static final int TEXT_ALIGN_Y = 21;
    public static final int TEXT_ALIGN_Z = 31;
    public static final int TEXT_STYLE = 7;
    public static final int TEXT_OBLIQUEANGLE = 51;
    public static final int TEXT_ROTATION = 50;
    protected DXFText text;
    protected String content;

    public void endDXFEntity() {
        this.text.setText(this.content);
        this.content = "";
    }

    public DXFEntity getDXFEntity() {
        return this.text;
    }

    public String getDXFEntityName() {
        return "TEXT";
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 1: {
                this.content = value.getValue();
                break;
            }
            case 72: {
                this.text.setAlign(value.getIntegerValue());
                break;
            }
            case 73: {
                this.text.setValign(value.getIntegerValue());
                break;
            }
            case 10: {
                this.text.setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.text.setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.text.setZ(value.getDoubleValue());
                break;
            }
            case 11: {
                this.text.setAlignX(value.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 21: {
                this.text.setAlignY(value.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 31: {
                this.text.setAlignZ(value.getDoubleValue());
                this.text.setAlignmentPoint(true);
                break;
            }
            case 40: {
                this.text.setHeight(value.getDoubleValue());
                break;
            }
            case 71: {
                switch (value.getIntegerValue()) {
                    case 2: {
                        this.text.setBackward(true);
                        break;
                    }
                    case 4: {
                        this.text.setUpsideDown(true);
                    }
                }
                break;
            }
            case 7: {
                this.text.setTextStyle(value.getValue());
                break;
            }
            case 50: {
                this.text.setRotation(value.getDoubleValue());
                break;
            }
            case 41: {
                this.text.setScaleX(value.getDoubleValue());
                break;
            }
            case 51: {
                this.text.setObliqueAngle(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.text);
            }
        }
    }

    public void startDXFEntity() {
        this.text = new DXFText();
        this.text.setDXFDocument(this.doc);
    }
}

