/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFRegion;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFRegionHandler
extends AbstractEntityHandler {
    protected static final int DATA = 1;
    protected static final int APPEND_DATA = 3;
    protected DXFRegion region;
    protected StringBuffer data = new StringBuffer();

    public String getDXFEntityName() {
        return "REGION";
    }

    public void startDXFEntity() {
        this.region = new DXFRegion();
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 1: {
                this.checkBuffer();
                this.data.append(value.getValue());
                break;
            }
            case 3: {
                this.data.append(value.getValue());
            }
        }
    }

    public DXFEntity getDXFEntity() {
        return this.region;
    }

    public void endDXFEntity() {
        this.checkBuffer();
    }

    public boolean isFollowSequence() {
        return false;
    }

    protected String decodeDATA(String s) {
        char[] c = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isWhitespace(c[i])) {
                buf.append(' ');
                continue;
            }
            int code = Math.abs(c[i] - 159);
            buf.append((char)code);
        }
        return buf.toString();
    }

    protected void checkBuffer() {
        if (this.data.length() > 0) {
            this.region.appendACISDATA(this.decodeDATA(this.data.toString()));
            this.data.delete(0, this.data.length());
        }
    }
}

