/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFPolylineHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "POLYLINE";
    public static final String ENTITY_VERTEX = "VERTEX";
    public static final String END_SEQUENCE = "SEQEND";
    public static final int END_SEQUENCE_CODE = -2;
    public static final int VERTEX_BULGE = 42;
    public static final int START_WIDTH = 40;
    public static final int END_WIDTH = 41;
    public static final int THICKNESS = 39;
    public static final int SURFACE_TYPE = 75;
    public static final int SUREFACE_DENSITY_ROW_COUNT = 73;
    public static final int SUREFACE_DENSITY_COLUMN_COUNT = 74;
    public static final int ROW_COUNT = 71;
    public static final int COLUMN_COUNT = 72;
    private boolean follow = true;
    private boolean parse_vertex = false;
    private DXFVertex vertex;
    private DXFPolyline polyline;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.polyline;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public boolean isFollowSequence() {
        return this.follow;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        if (groupCode == -2 || END_SEQUENCE.equals(value.getValue())) {
            this.polyline.addVertex(this.vertex);
            this.follow = false;
            return;
        }
        switch (groupCode) {
            case 0: {
                if (!ENTITY_VERTEX.equals(value.getValue())) break;
                if (this.parse_vertex) {
                    this.polyline.addVertex(this.vertex);
                } else {
                    this.parse_vertex = true;
                }
                this.vertex = new DXFVertex();
                this.vertex.setDXFDocument(this.doc);
                break;
            }
            case 10: {
                if (!this.parse_vertex) break;
                this.vertex.setX(value.getDoubleValue());
                break;
            }
            case 20: {
                if (!this.parse_vertex) break;
                this.vertex.setY(value.getDoubleValue());
                break;
            }
            case 30: {
                if (!this.parse_vertex) break;
                this.vertex.setZ(value.getDoubleValue());
                break;
            }
            case 42: {
                if (!this.parse_vertex) break;
                this.vertex.setBulge(value.getDoubleValue());
                break;
            }
            case 40: {
                if (this.parse_vertex) {
                    this.vertex.setStartWidth(value.getDoubleValue());
                    break;
                }
                this.polyline.setStartWidth(value.getDoubleValue());
                break;
            }
            case 41: {
                if (this.parse_vertex) {
                    this.vertex.setEndWidth(value.getDoubleValue());
                    break;
                }
                this.polyline.setEndWidth(value.getDoubleValue());
                break;
            }
            case 39: {
                this.polyline.setThickness(value.getDoubleValue());
                break;
            }
            case 75: {
                this.polyline.setSurefaceType(value.getIntegerValue());
                break;
            }
            case 71: {
                if (this.parse_vertex) {
                    this.vertex.setPolyFaceMeshVertex0(value.getIntegerValue());
                    break;
                }
                this.polyline.setRows(value.getIntegerValue());
                break;
            }
            case 72: {
                if (this.parse_vertex) {
                    this.vertex.setPolyFaceMeshVertex1(value.getIntegerValue());
                    break;
                }
                this.polyline.setColumns(value.getIntegerValue());
                break;
            }
            case 73: {
                if (this.parse_vertex) {
                    this.vertex.setPolyFaceMeshVertex2(value.getIntegerValue());
                    break;
                }
                this.polyline.setSurefaceDensityRows(value.getIntegerValue());
                break;
            }
            case 74: {
                if (this.parse_vertex) {
                    this.vertex.setPolyFaceMeshVertex3(value.getIntegerValue());
                    break;
                }
                this.polyline.setSurefaceDensityColumns(value.getIntegerValue());
                break;
            }
            default: {
                if (this.parse_vertex) {
                    super.parseCommonProperty(groupCode, value, this.vertex);
                    break;
                }
                super.parseCommonProperty(groupCode, value, this.polyline);
            }
        }
    }

    public void startDXFEntity() {
        this.follow = true;
        this.parse_vertex = false;
        this.polyline = new DXFPolyline();
    }
}

