/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFMText;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFMTextHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "MTEXT";
    public static final int TEXT_VALUE_END = 1;
    public static final int TEXT_VALUE = 3;
    public static final int TEXT_HEIGHT = 40;
    public static final int TEXT_REF_WIDTH = 41;
    public static final int TEXT_REF_HEIGHT = 43;
    public static final int TEXT_DRAWING_DIRECTION_FLAG = 72;
    public static final int TEXT_ATTACHMENT_POINT = 71;
    public static final int TEXT_VALIGN = 73;
    public static final int TEXT_ALIGN_X = 11;
    public static final int TEXT_ALIGN_Y = 21;
    public static final int TEXT_ALIGN_Z = 31;
    public static final int TEXT_STYLE = 7;
    public static final int TEXT_OBLIQUEANGLE = 51;
    public static final int TEXT_ROTATION = 50;
    private DXFMText mtext;
    private StringBuffer buf = new StringBuffer();
    private int insert = 0;

    public void endDXFEntity() {
        this.mtext.setText(this.buf.toString());
        this.buf.delete(0, this.buf.length());
    }

    public DXFEntity getDXFEntity() {
        return this.mtext;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 3: {
                String part = value.getValue();
                this.buf.insert(this.insert, part);
                this.insert += part.length();
                break;
            }
            case 1: {
                this.buf.insert(this.insert, value.getValue());
                break;
            }
            case 71: {
                this.mtext.setAttachmentPoint(value.getIntegerValue());
                break;
            }
            case 10: {
                this.mtext.setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.mtext.setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.mtext.setZ(value.getDoubleValue());
                break;
            }
            case 11: {
                this.mtext.setAlignX(value.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 21: {
                this.mtext.setAlignY(value.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 31: {
                this.mtext.setAlignZ(value.getDoubleValue());
                this.mtext.setRotation(0.0);
                break;
            }
            case 40: {
                this.mtext.setHeight(value.getDoubleValue());
                break;
            }
            case 72: {
                switch (value.getIntegerValue()) {
                    case 2: {
                        this.mtext.setBackward(true);
                        break;
                    }
                    case 4: {
                        this.mtext.setUpsideDown(true);
                    }
                }
                break;
            }
            case 7: {
                this.mtext.setTextStyle(value.getValue());
                break;
            }
            case 50: {
                this.mtext.setRotation(value.getDoubleValue());
                break;
            }
            case 41: {
                this.mtext.setReferenceWidth(value.getDoubleValue());
                break;
            }
            case 43: {
                this.mtext.setReferenceHeight(value.getDoubleValue());
                break;
            }
            case 51: {
                this.mtext.setObliqueAngle(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.mtext);
            }
        }
    }

    public void startDXFEntity() {
        this.mtext = new DXFMText();
        this.insert = 0;
    }
}

