/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLineHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "LINE";
    private DXFLine line;
    private DXFDocument doc;
    private String layerID = "";

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.line.getStartPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.line.getStartPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.line.getStartPoint().setZ(value.getDoubleValue());
                break;
            }
            case 11: {
                this.line.getEndPoint().setX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.line.getEndPoint().setY(value.getDoubleValue());
                break;
            }
            case 31: {
                this.line.getEndPoint().setZ(value.getDoubleValue());
            }
        }
        super.parseCommonProperty(groupCode, value, this.line);
    }

    public DXFEntity getDXFEntity() {
        return this.line;
    }

    public void startDXFEntity() {
        this.line = new DXFLine();
        this.line.setStartPoint(new Point());
        this.line.setEndPoint(new Point());
    }

    public void endDXFEntity() {
    }

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
    }

    public boolean isFollowSequence() {
        return false;
    }
}

