/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFImage;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFImageHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_IMAGEDEF_HARDREFERENCE = 340;
    public static final int GROUPCODE_VECTOR_U_X = 11;
    public static final int GROUPCODE_VECTOR_U_Y = 21;
    public static final int GROUPCODE_VECTOR_U_Z = 31;
    public static final int GROUPCODE_VECTOR_V_X = 12;
    public static final int GROUPCODE_VECTOR_V_Y = 22;
    public static final int GROUPCODE_VECTOR_V_Z = 32;
    public static final int GROUPCODE_IAMGESIZE_U = 13;
    public static final int GROUPCODE_IAMGESIZE_V = 23;
    public static final int GROUPCODE_DISPLAY_PROPERTY = 70;
    public static final int GROUPCODE_BRIGHTNESS = 281;
    public static final int GROUPCODE_CONTRAST = 282;
    public static final int GROUPCODE_FADE = 283;
    public static final int GROUPCODE_NUMBER_CLIP_BOUNDARY = 91;
    public static final int GROUPCODE_CLIP_BOUNDARY_X = 14;
    public static final int GROUPCODE_CLIP_BOUNDARY_Y = 24;
    public static final int GROUPCODE_CLIP_BOUNDARY_TYPE = 71;
    public static final int GROUPCODE_CLIPPING_STATE = 280;
    protected DXFImage image;
    protected Point clippingPoint;

    public String getDXFEntityName() {
        return "IMAGE";
    }

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.image;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.image.getInsertPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.image.getInsertPoint().setY(value.getDoubleValue());
                break;
            }
            case 30: {
                this.image.getInsertPoint().setZ(value.getDoubleValue());
                break;
            }
            case 340: {
                this.image.setImageDefObjectID(value.getValue());
                break;
            }
            case 11: {
                this.image.getVectorU().setX(value.getDoubleValue());
                break;
            }
            case 21: {
                this.image.getVectorU().setY(value.getDoubleValue());
                break;
            }
            case 31: {
                this.image.getVectorU().setZ(value.getDoubleValue());
                break;
            }
            case 12: {
                this.image.getVectorV().setX(value.getDoubleValue());
                break;
            }
            case 22: {
                this.image.getVectorV().setY(value.getDoubleValue());
                break;
            }
            case 32: {
                this.image.getVectorV().setZ(value.getDoubleValue());
                break;
            }
            case 13: {
                this.image.setImageSizeAlongU(value.getDoubleValue());
                break;
            }
            case 23: {
                this.image.setImageSizeAlongV(value.getDoubleValue());
                break;
            }
            case 280: {
                this.image.setClipping(value.getBooleanValue());
                break;
            }
            case 14: {
                this.clippingPoint = new Point();
                this.clippingPoint.setX(value.getDoubleValue());
                this.image.addClippingPoint(this.clippingPoint);
                break;
            }
            case 24: {
                this.clippingPoint.setY(value.getDoubleValue());
                break;
            }
            case 281: {
                this.image.setBrightness(value.getDoubleValue());
                break;
            }
            case 282: {
                this.image.setContrast(value.getDoubleValue());
                break;
            }
            case 283: {
                this.image.setFade(value.getDoubleValue());
                break;
            }
            case 71: {
                if (value.getIntegerValue() == 1) {
                    this.image.setRectangularClipping(true);
                    break;
                }
                if (value.getIntegerValue() != 2) break;
                this.image.setPolygonalClipping(true);
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.image);
            }
        }
    }

    public void startDXFEntity() {
        this.image = new DXFImage();
        this.image.setDXFDocument(this.doc);
    }
}

