/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFCircle;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFCircleHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "CIRCLE";
    public static final int RADIUS = 40;
    private DXFCircle circle;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.circle;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        switch (groupCode) {
            case 10: {
                this.circle.getCenterPoint().setX(value.getDoubleValue());
                break;
            }
            case 20: {
                this.circle.getCenterPoint().setY(value.getDoubleValue());
                break;
            }
            case 40: {
                this.circle.setRadius(value.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(groupCode, value, this.circle);
            }
        }
    }

    public void startDXFEntity() {
        this.circle = new DXFCircle();
        this.circle.setCenterPoint(new Point());
        this.circle.setDXFDocument(this.doc);
    }

    public boolean isFollowSequence() {
        return false;
    }
}

