/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.DXFSectionHandler;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.Handler;
import org.kabeja.parser.HandlerManager;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.Parser;
import org.kabeja.parser.dxf.DXFHandler;
import org.kabeja.parser.dxf.filter.DXFStreamFilter;
import org.kabeja.tools.CodePageParser;

public class DXFParser
implements HandlerManager,
Handler,
Parser,
DXFHandler {
    public static final String PARSER_NAME = "DXFParser";
    public static final String EXTENSION = "dxf";
    private static final String SECTION_START = "SECTION";
    private static final String SECTION_END = "ENDSEC";
    private static final String END_STREAM = "EOF";
    private static final int COMMAND_CODE = 0;
    public static final String DEFAULT_ENCODING = "";
    protected DXFDocument doc;
    protected Hashtable handlers = new Hashtable();
    protected DXFSectionHandler currentHandler;
    private String line;
    protected List streamFilters = new ArrayList();
    protected DXFHandler filter;
    private boolean key = false;
    private boolean sectionstarts = false;
    private int linecount;
    private boolean parse = false;

    public void parse(String file) throws ParseException {
        this.parse(file, DEFAULT_ENCODING);
    }

    public void parse(String file, String encoding) throws ParseException {
        try {
            this.parse(new FileInputStream(file), encoding);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void parse(InputStream input, String encoding) throws ParseException {
        String currentKey = DEFAULT_ENCODING;
        this.key = false;
        this.linecount = 0;
        this.parse = false;
        this.doc = new DXFDocument();
        this.doc.setProperty(DXFDocument.PROPERTY_ENCODING, encoding);
        this.buildFilterChain();
        BufferedReader in = null;
        try {
            if (DEFAULT_ENCODING.equals(encoding)) {
                BufferedInputStream buf = new BufferedInputStream(input);
                buf.mark(9000);
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(buf));
                    CodePageParser p = new CodePageParser();
                    encoding = p.parseEncoding(r);
                    buf.reset();
                    in = new BufferedReader(new InputStreamReader((InputStream)buf, encoding));
                }
                catch (IOException e1) {
                    buf.reset();
                    in = new BufferedReader(new InputStreamReader(buf));
                }
            } else {
                in = new BufferedReader(new InputStreamReader(input, encoding));
            }
            this.key = true;
            this.sectionstarts = false;
            while ((this.line = in.readLine()) != null) {
                ++this.linecount;
                if (this.key) {
                    currentKey = this.line;
                    this.key = false;
                    continue;
                }
                int keyCode = Integer.parseInt(currentKey.trim());
                this.filter.parseGroup(keyCode, new DXFValue(this.line.trim()));
                this.key = true;
            }
            in.close();
            in = null;
            if (this.parse) {
                this.currentHandler.endSection();
            }
        }
        catch (FileNotFoundException e) {
            throw new ParseException(e.toString());
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.toString());
        }
    }

    public void parseGroup(int keyCode, DXFValue value) throws ParseException {
        try {
            if (this.sectionstarts) {
                this.sectionstarts = false;
                if (this.handlers.containsKey(value.getValue())) {
                    this.currentHandler = (DXFSectionHandler)this.handlers.get(value.getValue());
                    this.parse = true;
                    this.currentHandler.setDXFDocument(this.doc);
                    this.currentHandler.startSection();
                } else {
                    this.parse = false;
                }
                return;
            }
            if (keyCode == 0 && SECTION_START.equals(value.getValue()) && !this.sectionstarts) {
                this.sectionstarts = true;
            }
            if (keyCode == 0 && SECTION_END.equals(value.getValue())) {
                if (this.parse) {
                    this.currentHandler.endSection();
                }
                this.parse = false;
                return;
            }
            if (this.parse) {
                this.currentHandler.parseGroup(keyCode, value);
            }
            return;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new ParseException("Line: " + this.linecount + " unsupported groupcode: " + this.key + " for value:" + value, e);
        }
    }

    public DXFDocument getDocument() {
        return this.doc;
    }

    public void addDXFSectionHandler(DXFSectionHandler handler) {
        handler.setDXFDocument(this.doc);
        this.handlers.put(handler.getSectionKey(), handler);
    }

    public void addHandler(Handler handler) {
        this.addDXFSectionHandler((DXFSectionHandler)handler);
    }

    public void releaseDXFDocument() {
        this.doc = null;
        Iterator i = this.handlers.values().iterator();
        while (i.hasNext()) {
            Handler handler = (Handler)i.next();
            handler.releaseDXFDocument();
        }
    }

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
    }

    public boolean supportedExtension(String extension) {
        return extension.toLowerCase().equals(EXTENSION);
    }

    public void addDXFStreamFilter(DXFStreamFilter filter) {
        this.streamFilters.add(filter);
    }

    public void removeDXFStreamFilter(DXFStreamFilter filter) {
        this.streamFilters.remove(filter);
    }

    protected void buildFilterChain() {
        DXFHandler handler = this;
        for (int i = this.streamFilters.size() - 1; i >= 0; --i) {
            DXFStreamFilter f = (DXFStreamFilter)this.streamFilters.get(i);
            f.setDXFHandler(handler);
            handler = f;
        }
        this.filter = handler;
    }

    public String getName() {
        return PARSER_NAME;
    }
}

