/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser;

import java.util.HashMap;
import org.kabeja.parser.AbstractSectionHandler;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.Handler;
import org.kabeja.parser.HandlerManager;
import org.kabeja.parser.objects.DXFObjectHandler;

public class DXFObjectsSectionHandler
extends AbstractSectionHandler
implements HandlerManager {
    private static String SECTION_KEY = "OBJECTS";
    public static final int OBJECT_START = 0;
    private HashMap handlers = new HashMap();
    private DXFObjectHandler handler;
    private boolean parseObject = false;

    public void endSection() {
        this.endObject();
    }

    public String getSectionKey() {
        return SECTION_KEY;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        if (groupCode == 0) {
            this.endObject();
            if (this.handlers.containsKey(value.getValue())) {
                this.parseObject = true;
                this.handler = (DXFObjectHandler)this.handlers.get(value.getValue());
                this.handler.setDXFDocument(this.doc);
                this.handler.startObject();
            } else {
                this.parseObject = false;
            }
        } else if (this.parseObject) {
            this.handler.parseGroup(groupCode, value);
        }
    }

    public void startSection() {
        this.parseObject = false;
    }

    public void releaseDXFDocument() {
        this.doc = null;
    }

    public void addHandler(Handler handler) {
        DXFObjectHandler h = (DXFObjectHandler)handler;
        h.setDXFDocument(this.doc);
        this.handlers.put(h.getObjectType(), h);
    }

    protected void endObject() {
        if (this.parseObject) {
            this.handler.endObject();
            this.doc.addDXFObject(this.handler.getDXFObject());
        }
    }
}

