/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser;

import java.util.Hashtable;
import java.util.Iterator;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.parser.AbstractSectionHandler;
import org.kabeja.parser.DXFSectionHandler;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.Handler;
import org.kabeja.parser.HandlerManager;
import org.kabeja.parser.entities.DXFEntityHandler;

public class DXFEntitiesSectionHandler
extends AbstractSectionHandler
implements DXFSectionHandler,
HandlerManager {
    private static String SECTION_KEY = "ENTITIES";
    public static final int ENTITY_START = 0;
    protected Hashtable handlers = new Hashtable();
    protected DXFEntityHandler handler = null;
    protected boolean parseEntity = false;

    public String getSectionKey() {
        return SECTION_KEY;
    }

    public void parseGroup(int groupCode, DXFValue value) {
        if (groupCode == 0) {
            if (this.parseEntity) {
                if (this.handler.isFollowSequence()) {
                    this.handler.parseGroup(groupCode, value);
                    return;
                }
                this.endEntity();
            }
            if (this.handlers.containsKey(value.getValue())) {
                this.handler = (DXFEntityHandler)this.handlers.get(value.getValue());
                this.handler.setDXFDocument(this.doc);
                this.handler.startDXFEntity();
                this.parseEntity = true;
            } else {
                this.parseEntity = false;
            }
        } else if (this.parseEntity) {
            this.handler.parseGroup(groupCode, value);
        }
    }

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
    }

    public void endSection() {
        this.endEntity();
    }

    public void startSection() {
        this.parseEntity = false;
    }

    protected void endEntity() {
        if (this.parseEntity) {
            this.handler.endDXFEntity();
            DXFEntity entity = this.handler.getDXFEntity();
            this.doc.addDXFEntity(entity);
        }
    }

    public void addDXFEntityHandler(DXFEntityHandler handler) {
        handler.setDXFDocument(this.doc);
        this.handlers.put(handler.getDXFEntityName(), handler);
    }

    public void addHandler(Handler handler) {
        this.addDXFEntityHandler((DXFEntityHandler)handler);
    }

    public void releaseDXFDocument() {
        this.doc = null;
        Iterator i = this.handlers.values().iterator();
        while (i.hasNext()) {
            Handler handler = (Handler)i.next();
            handler.releaseDXFDocument();
        }
    }
}

