/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import java.util.Iterator;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.NURBS;

public class NURBSFixedNTELSPointIterator
implements Iterator {
    private NURBS nurbs;
    private int ntels;
    private double dt = 0.0;
    private double t = 0.0;
    private int interval;
    private int lastInterval;

    public NURBSFixedNTELSPointIterator(NURBS nurbs, int ntels) {
        this.nurbs = nurbs;
        this.ntels = ntels;
        if (this.nurbs.getKnots().length == this.nurbs.getDegree() + this.nurbs.controlPoints.length + 1) {
            this.lastInterval = this.nurbs.getKnots().length - this.nurbs.getDegree() - 1;
            this.interval = this.nurbs.getDegree();
        } else if (this.nurbs.getKnots().length > 0) {
            this.interval = 0;
            double start = this.nurbs.getKnots()[0];
            while (start == this.nurbs.getKnots()[this.interval + 1]) {
                ++this.interval;
            }
            this.lastInterval = this.nurbs.getKnots().length - 1;
            double end = this.nurbs.getKnots()[this.lastInterval];
            while (end == this.nurbs.getKnots()[this.lastInterval]) {
                --this.lastInterval;
            }
        }
        this.t = this.nurbs.getKnots()[this.nurbs.getDegree()];
        this.nextInterval();
        if (this.interval - 1 < this.nurbs.getDegree()) {
            this.interval = this.nurbs.getDegree() + 1;
        }
    }

    public boolean hasNext() {
        if (this.t < this.nurbs.getKnots()[this.interval]) {
            return true;
        }
        if (this.interval < this.lastInterval) {
            this.nextInterval();
            return this.hasNext();
        }
        return false;
    }

    public Object next() {
        Point p = this.nurbs.getPointAt(this.interval - 1, this.t);
        this.t += this.dt;
        return p;
    }

    public void remove() {
    }

    protected void nextInterval() {
        ++this.interval;
        while (this.t > this.nurbs.getKnots()[this.interval] && this.interval < this.lastInterval) {
            ++this.interval;
        }
        double length = this.nurbs.getKnots()[this.interval] - this.t;
        this.dt = length / (double)this.ntels;
    }
}

