/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;

public class MathUtils {
    public static final double DISTANCE_DELTA = 1.0E-5;

    public static double scalarProduct(Vector a, Vector b) {
        double r = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
        return r;
    }

    public static double absoluteValue(Vector v) {
        double r = Math.sqrt(Math.pow(v.getX(), 2.0) + Math.pow(v.getY(), 2.0) + Math.pow(v.getZ(), 2.0));
        return r;
    }

    public static Vector crossProduct(Vector a, Vector b) {
        Vector r = new Vector();
        r.setX(a.getY() * b.getZ() - a.getZ() * b.getY());
        r.setY(a.getZ() * b.getX() - a.getX() * b.getZ());
        r.setZ(a.getX() * b.getY() - a.getY() * b.getX());
        return r;
    }

    public static Vector scaleVector(Vector a, double scale) {
        Vector v = new Vector();
        v.setX(a.getX() * scale);
        v.setY(a.getY() * scale);
        v.setZ(a.getZ() * scale);
        return v;
    }

    public static Point getPointOfStraightLine(Point a, Vector direction, double parameter) {
        Point p = new Point();
        Vector v = MathUtils.scaleVector(direction, parameter);
        p.setX(a.getX() + v.getX());
        p.setY(a.getY() + v.getY());
        p.setZ(a.getZ() + v.getZ());
        return p;
    }

    public static Vector getVector(Point a, Point b) {
        Vector v = new Vector();
        v.setX(b.getX() - a.getX());
        v.setY(b.getY() - a.getY());
        v.setZ(b.getZ() - a.getZ());
        return v;
    }

    public static Point getIntersection(Point a, Vector u, Point b, Vector v) {
        Vector n = MathUtils.crossProduct(u, v);
        Vector m = MathUtils.crossProduct(MathUtils.getVector(a, b), v);
        double s = 0.0;
        if (n.getZ() != 0.0) {
            s = m.getZ() / n.getZ();
        } else if (n.getY() != 0.0) {
            s = m.getY() / n.getY();
        } else if (n.getX() != 0.0) {
            s = m.getX() / n.getX();
        }
        Point p = MathUtils.getPointOfStraightLine(a, u, s);
        return p;
    }

    public static double distance(Point start, Point end) {
        double length = Math.sqrt(Math.pow(end.getX() - start.getX(), 2.0) + Math.pow(end.getY() - start.getY(), 2.0) + Math.pow(end.getZ() - start.getZ(), 2.0));
        return length;
    }

    public static double getAngle(Vector a, Vector b) {
        double cos = MathUtils.scalarProduct(a, b) / (MathUtils.absoluteValue(a) * MathUtils.absoluteValue(b));
        return Math.acos(cos);
    }

    public static Point rotatePointXY(Point p, Point center, double angle) {
        Point r = new Point();
        r.setX(center.getX() + Math.cos(angle) * (p.getX() - center.getX()) - (p.getY() - center.getY()) * Math.sin(angle));
        r.setY(center.getY() + Math.cos(angle) * (p.getY() - center.getY()) - (p.getX() - center.getX()) * Math.sin(angle));
        r.setZ(p.getZ());
        return r;
    }

    public static Vector normalize(Vector v) {
        double l = MathUtils.absoluteValue(v);
        return MathUtils.scaleVector(v, 1.0 / l);
    }

    public static int getQuadrant(Point p, Point center) {
        if (p.getX() < center.getX()) {
            if (p.getY() >= center.getY()) {
                return 1;
            }
            return 2;
        }
        if (p.getY() >= center.getY()) {
            return 0;
        }
        return 3;
    }

    public static int getQuadrant(double angle) {
        if (angle > 360.0) {
            angle -= Math.floor(angle / 360.0) * 360.0;
        }
        if (angle >= 0.0 && angle < 90.0) {
            return 0;
        }
        if (angle >= 90.0 && angle < 180.0) {
            return 1;
        }
        if (angle >= 180.0 && angle < 270.0) {
            return 2;
        }
        return 3;
    }

    public static double getDirectionAngle(Vector v) {
        double l = MathUtils.absoluteValue(v);
        if (v.getX() < 0.0 && v.getY() < 0.0) {
            return Math.toDegrees(Math.acos(Math.abs(v.getX() / l))) + 180.0;
        }
        if (v.getX() == 0.0 || v.getY() < 0.0) {
            return Math.toDegrees(Math.asin(v.getY() / l));
        }
        return Math.toDegrees(Math.acos(v.getX() / l));
    }

    public static Vector invertDirection(Vector v) {
        return MathUtils.scaleVector(v, -1.0);
    }

    public static double[][] multiplyMatrixByMatrix(double[][] a, double[][] b) throws IllegalArgumentException {
        if (a[0].length != b.length) {
            throw new IllegalArgumentException("Cannot multiply a with b, columns of a != rows of b. ");
        }
        double[][] c = new double[a.length][b[0].length];
        for (int i = 0; i < a.length; ++i) {
            for (int x = 0; x < b[0].length; ++x) {
                for (int y = 0; y < b.length; ++y) {
                    double[] dArray = c[i];
                    int n = x;
                    dArray[n] = dArray[n] + a[i][y] * b[x][y];
                }
            }
        }
        return c;
    }

    public static double[] multiplyMatrixByVector(double[][] a, double[] v) throws IllegalArgumentException {
        if (a[0].length != v.length) {
            throw new IllegalArgumentException("Cannot multiply a with v, columns of a != rows of v. ");
        }
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            for (int x = 0; x < v.length; ++x) {
                int n = i;
                r[n] = r[n] + a[i][x] * v[x];
            }
        }
        return r;
    }

    public static Vector subtractVectorByVector(Vector a, Vector b) {
        Vector result = new Vector();
        result.setX(a.getX() - b.getX());
        result.setY(a.getY() - b.getY());
        result.setZ(a.getZ() - b.getZ());
        return result;
    }

    public static Vector addVectorToVector(Vector a, Vector b) {
        Vector result = new Vector();
        result.setX(a.getX() + b.getX());
        result.setY(a.getY() + b.getY());
        result.setZ(a.getZ() + b.getZ());
        return result;
    }
}

