/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.helpers.StyledTextParagraph;

public class TextDocument {
    protected List paragraphs = new ArrayList();

    public String getText() {
        Iterator i = this.paragraphs.iterator();
        StringBuffer buf = new StringBuffer();
        while (i.hasNext()) {
            StyledTextParagraph para = (StyledTextParagraph)i.next();
            buf.append(para.getText());
            if (!para.isNewline()) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public void addStyledParagraph(StyledTextParagraph para) {
        this.paragraphs.add(para);
    }

    public Iterator getStyledParagraphIterator() {
        return this.paragraphs.iterator();
    }

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    public StyledTextParagraph getStyleTextParagraph(int i) {
        return (StyledTextParagraph)this.paragraphs.get(i);
    }

    public int getLineCount() {
        int count = 1;
        Iterator i = this.paragraphs.iterator();
        while (i.hasNext()) {
            StyledTextParagraph para = (StyledTextParagraph)i.next();
            if (!para.isNewline()) continue;
            ++count;
        }
        return count;
    }

    public int getMaximumLineLength() {
        int count = 0;
        int max = 0;
        Iterator i = this.paragraphs.iterator();
        while (i.hasNext()) {
            StyledTextParagraph para = (StyledTextParagraph)i.next();
            if (!para.isNewline()) {
                count += para.getLength();
                continue;
            }
            if (count > max) {
                max = count;
            }
            count = para.getLength();
        }
        return max;
    }
}

