/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class PolylineSegment {
    public static double DELTA = 0.001;
    private boolean bulged = false;
    private Point point1 = new Point();
    private Point point2 = new Point();
    private Point point3 = new Point();
    private Point point4 = new Point();
    private double radius;
    private double bulgeHeight;
    private double innerRadius;
    private double outerRadius;
    private DXFVertex start;
    private DXFPolyline p;

    public PolylineSegment(DXFVertex start, DXFVertex end, DXFPolyline p) {
        this.start = start;
        this.p = p;
        if (this.start.getBulge() != 0.0) {
            double l = MathUtils.distance(start.getPoint(), end.getPoint());
            this.radius = this.getRadius(Math.abs(start.getBulge()), l);
            this.bulgeHeight = start.getBulge() * l / 2.0;
            this.setBulged(true);
            this.createCurvedTrapezium(start, end, this.radius, l);
        } else {
            this.createTrapezium(start, end);
        }
    }

    public double getBulge() {
        return this.start.getBulge();
    }

    public boolean isBulged() {
        return this.bulged;
    }

    public void setBulged(boolean bulged) {
        this.bulged = bulged;
    }

    public Point getPoint1() {
        return this.point1;
    }

    public void setPoint1(Point point1) {
        this.point1 = point1;
    }

    public Point getPoint2() {
        return this.point2;
    }

    public void setPoint2(Point point2) {
        this.point2 = point2;
    }

    public Point getPoint3() {
        return this.point3;
    }

    public void setPoint3(Point point3) {
        this.point3 = point3;
    }

    public Point getPoint4() {
        return this.point4;
    }

    public void setPoint4(Point point4) {
        this.point4 = point4;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    protected void createCurvedTrapezium(DXFVertex start, DXFVertex end, double radius, double length) {
        double t;
        double s = length / 2.0;
        Vector edgeDirection = MathUtils.getVector(start.getPoint(), end.getPoint());
        edgeDirection = MathUtils.normalize(edgeDirection);
        Point mp = MathUtils.getPointOfStraightLine(start.getPoint(), edgeDirection, s);
        Vector d = this.p.getExtrusion().getNormal();
        d = MathUtils.crossProduct(d, edgeDirection);
        d = MathUtils.normalize(d);
        double h = Math.abs(start.getBulge() * length) / 2.0;
        double r = this.p.getRadius(start.getBulge(), length);
        boolean right = false;
        if (start.getBulge() > 0.0) {
            t = h - r;
            mp = MathUtils.getPointOfStraightLine(mp, d, t);
        } else {
            right = true;
            t = r - h;
            mp = MathUtils.getPointOfStraightLine(mp, d, t);
        }
        double c = 0.0;
        c = start.getStartWidth() > 0.0 ? start.getStartWidth() / 2.0 : this.p.getStartWidth() / 2.0;
        if (start.getBulge() > 0.0) {
            c = -1.0 * c;
        }
        d = MathUtils.getVector(start.getPoint(), mp);
        d = MathUtils.normalize(d);
        this.point1 = MathUtils.getPointOfStraightLine(start.getPoint(), d, c);
        this.point2 = MathUtils.getPointOfStraightLine(start.getPoint(), d, c * -1.0);
        c = start.getEndWidth() > 0.0 ? start.getEndWidth() / 2.0 : this.p.getEndWidth() / 2.0;
        if (start.getBulge() > 0.0) {
            c = -1.0 * c;
        }
        d = MathUtils.getVector(end.getPoint(), mp);
        d = MathUtils.normalize(d);
        this.point3 = MathUtils.getPointOfStraightLine(end.getPoint(), d, c * -1.0);
        this.point4 = MathUtils.getPointOfStraightLine(end.getPoint(), d, c);
    }

    protected void createTrapezium(DXFVertex start, DXFVertex end) {
        double c = 0.0;
        c = start.getStartWidth() > 0.0 ? start.getStartWidth() / 2.0 : this.p.getStartWidth() / 2.0;
        Vector v = this.p.getExtrusion().getNormal();
        Vector x = MathUtils.getVector(start.getPoint(), end.getPoint());
        v = MathUtils.crossProduct(v, x);
        v = MathUtils.normalize(v);
        this.point1 = MathUtils.getPointOfStraightLine(start.getPoint(), v, c);
        this.point2 = MathUtils.getPointOfStraightLine(start.getPoint(), v, -1.0 * c);
        c = start.getEndWidth() > 0.0 ? start.getEndWidth() / 2.0 : this.p.getEndWidth() / 2.0;
        this.point3 = MathUtils.getPointOfStraightLine(end.getPoint(), v, -1.0 * c);
        this.point4 = MathUtils.getPointOfStraightLine(end.getPoint(), v, c);
    }

    protected double getRadius(double bulge, double length) {
        double h = bulge * length / 2.0;
        double value = h / 2.0 + Math.pow(length, 2.0) / (8.0 * h);
        return value;
    }

    public double getBulgeHeight() {
        return this.bulgeHeight;
    }

    public void connect(PolylineSegment next) {
        Vector d2;
        Vector d1 = MathUtils.getVector(this.point1, this.point4);
        double angle = MathUtils.getAngle(d1, d2 = MathUtils.getVector(next.getPoint4(), next.getPoint1()));
        if (Math.abs(angle) > DELTA) {
            Point p = MathUtils.getIntersection(this.point1, d1, next.getPoint4(), d2);
            this.setPoint4(p);
            next.setPoint1(p);
            d1 = MathUtils.getVector(this.point2, this.point3);
            d2 = MathUtils.getVector(next.getPoint3(), next.getPoint2());
            p = MathUtils.getIntersection(this.point2, d1, next.getPoint3(), d2);
            this.setPoint3(p);
            next.setPoint2(p);
        }
    }

    public double getInnerRadius() {
        double r = (this.start.getStartWidth() + this.start.getEndWidth()) / 2.0;
        if (r == 0.0) {
            r = (this.p.getStartWidth() + this.p.getEndWidth()) / 2.0;
        }
        return this.getRadius() - r;
    }

    public double getOuterRadius() {
        double r = (this.start.getStartWidth() + this.start.getEndWidth()) / 2.0;
        if (r == 0.0) {
            r = (this.p.getStartWidth() + this.p.getEndWidth()) / 2.0;
        }
        return this.getRadius() + r;
    }
}

