/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import org.kabeja.dxf.DXFMLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.DXFMLineSegment;
import org.kabeja.dxf.helpers.DXFMLineSegmentElement;
import org.kabeja.dxf.helpers.ParametricLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.dxf.objects.DXFMLineStyle;
import org.kabeja.dxf.objects.DXFMLineStyleElement;
import org.kabeja.math.MathUtils;

public class MLineConverter {
    public static DXFPolyline[] toDXFPolyline(DXFMLine mline) {
        DXFMLineStyle style = (DXFMLineStyle)mline.getDXFDocument().getDXFObjectByID(mline.getMLineStyleID());
        DXFPolyline[] pl = new DXFPolyline[style.getDXFMLineStyleLElementCount()];
        for (int x = 0; x < pl.length; ++x) {
            DXFMLineStyleElement se = style.getDXFMLineStyleLElement(x);
            pl[x] = new DXFPolyline();
            pl[x].setDXFDocument(mline.getDXFDocument());
            pl[x].setLineType(se.getLineType());
            pl[x].setColor(se.getLineColor());
            if (!mline.isClosed()) continue;
            pl[x].setFlags(1);
        }
        Vector v = new Vector();
        Vector d = new Vector();
        ParametricLine l = new ParametricLine();
        ParametricLine miter = new ParametricLine();
        for (int i = 0; i < mline.getDXFMLineSegmentCount(); ++i) {
            DXFMLineSegment seg = mline.getDXFMLineSegment(i);
            v = seg.getDirection();
            d = seg.getMiterDirection();
            miter.setStartPoint(seg.getStartPoint());
            miter.setDirectionVector(d);
            for (int x = 0; x < seg.getDXFMLineSegmentElementCount(); ++x) {
                DXFMLineSegmentElement segEl = seg.getDXFMLineSegmentElement(x);
                double[] le = segEl.getLengthParameters();
                Point s = miter.getPointAt(le[0]);
                l.setStartPoint(s);
                l.setDirectionVector(v);
                pl[x].addVertex(new DXFVertex(l.getPointAt(le[1])));
            }
        }
        if (style.hasEndRoundCaps()) {
            Point p1 = pl[0].getVertex(pl[0].getVertexCount() - 1).getPoint();
            Point p2 = pl[pl.length - 1].getVertex(pl[pl.length - 1].getVertexCount() - 1).getPoint();
            Vector v1 = MathUtils.getVector(p1, p2);
            double distance = v1.getLength();
            double r = distance / 2.0;
            double length = Math.sqrt(2.0) * r;
            double h = r - Math.sqrt(0.5) * r;
            double bulge = h * 2.0 / length;
            v1.normalize();
            ParametricLine line = new ParametricLine(p1, v1);
            Point center = line.getPointAt(r);
            line.setStartPoint(center);
            v.normalize();
            line.setDirectionVector(v);
            center = line.getPointAt(r);
            pl[0].getVertex(pl[0].getVertexCount() - 1).setBulge(-1.0 * bulge);
            pl[0].addVertex(new DXFVertex(center));
            pl[pl.length - 1].getVertex(pl[pl.length - 1].getVertexCount() - 1).setBulge(bulge);
            pl[pl.length - 1].addVertex(new DXFVertex(center));
        }
        return pl;
    }
}

